/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.function.Predicates;

public class TransportTestUtil {
    private final Neo4jPack neo4jPack;

    public TransportTestUtil(Neo4jPack neo4jPack) {
        this.neo4jPack = neo4jPack;
    }

    public Neo4jPack getNeo4jPack() {
        return this.neo4jPack;
    }

    public byte[] chunk(RequestMessage ... messages) throws IOException {
        return this.chunk(32, messages);
    }

    public byte[] chunk(ResponseMessage ... messages) throws IOException {
        return this.chunk(32, messages);
    }

    public byte[] chunk(int chunkSize, RequestMessage ... messages) throws IOException {
        byte[][] serializedMessages = new byte[messages.length][];
        for (int i = 0; i < messages.length; ++i) {
            serializedMessages[i] = MessageMatchers.serialize(this.neo4jPack, messages[i]);
        }
        return this.chunk(chunkSize, serializedMessages);
    }

    public byte[] chunk(int chunkSize, ResponseMessage ... messages) throws IOException {
        byte[][] serializedMessages = new byte[messages.length][];
        for (int i = 0; i < messages.length; ++i) {
            serializedMessages[i] = MessageMatchers.serialize(this.neo4jPack, messages[i]);
        }
        return this.chunk(chunkSize, serializedMessages);
    }

    public byte[] chunk(int chunkSize, byte[] ... messages) {
        ByteBuffer output = ByteBuffer.allocate(10000).order(ByteOrder.BIG_ENDIAN);
        for (byte[] wholeMessage : messages) {
            int size;
            for (int left = wholeMessage.length; left > 0; left -= size) {
                size = Math.min(left, chunkSize);
                output.putShort((short)size);
                int offset = wholeMessage.length - left;
                output.put(wholeMessage, offset, size);
            }
            output.putShort((short)0);
        }
        output.flip();
        byte[] arrayOutput = new byte[output.limit()];
        output.get(arrayOutput);
        return arrayOutput;
    }

    public byte[] defaultAcceptedVersions() {
        return this.acceptedVersions(this.neo4jPack.version(), 0L, 0L, 0L);
    }

    public byte[] acceptedVersions(long option1, long option2, long option3, long option4) {
        ByteBuffer bb = ByteBuffer.allocate(20).order(ByteOrder.BIG_ENDIAN);
        bb.putInt(1616949271);
        bb.putInt((int)option1);
        bb.putInt((int)option2);
        bb.putInt((int)option3);
        bb.putInt((int)option4);
        return bb.array();
    }

    @SafeVarargs
    public final Matcher<TransportConnection> eventuallyReceives(final Matcher<ResponseMessage> ... messages) {
        return new TypeSafeMatcher<TransportConnection>(){

            protected boolean matchesSafely(TransportConnection conn) {
                try {
                    for (Matcher matchesMessage : messages) {
                        ResponseMessage message = TransportTestUtil.this.receiveOneResponseMessage(conn);
                        MatcherAssert.assertThat((Object)message, (Matcher)matchesMessage);
                    }
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendValueList("Messages[", ",", "]", (Object[])messages);
            }
        };
    }

    public ResponseMessage receiveOneResponseMessage(TransportConnection conn) throws IOException, InterruptedException {
        int size;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((size = this.receiveChunkHeader(conn)) > 0) {
            byte[] received = conn.recv(size);
            bytes.write(received);
        }
        return MessageMatchers.responseMessage(this.neo4jPack, bytes.toByteArray());
    }

    public int receiveChunkHeader(TransportConnection conn) throws IOException, InterruptedException {
        byte[] raw = conn.recv(2);
        return ((raw[0] & 0xFF) << 8 | raw[1] & 0xFF) & 0xFFFF;
    }

    public Matcher<TransportConnection> eventuallyReceivesSelectedProtocolVersion() {
        return TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, (byte)this.neo4jPack.version()});
    }

    public static Matcher<TransportConnection> eventuallyReceives(final byte[] expected) {
        return new TypeSafeMatcher<TransportConnection>(){
            byte[] received;

            protected boolean matchesSafely(TransportConnection item) {
                try {
                    this.received = item.recv(expected.length);
                    return Arrays.equals(this.received, expected);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("to receive ");
                this.appendBytes(description, expected);
            }

            protected void describeMismatchSafely(TransportConnection item, Description mismatchDescription) {
                mismatchDescription.appendText("received ");
                this.appendBytes(mismatchDescription, this.received);
            }

            void appendBytes(Description description, byte[] bytes) {
                description.appendValueList("RawBytes[", ",", "]", (Object[])new byte[][]{bytes});
            }
        };
    }

    public static Matcher<TransportConnection> eventuallyDisconnects() {
        return new TypeSafeMatcher<TransportConnection>(){

            protected boolean matchesSafely(TransportConnection connection) {
                BooleanSupplier condition = () -> {
                    try {
                        connection.send(new byte[]{0, 0});
                        connection.recv(1);
                    }
                    catch (Exception e) {
                        return e instanceof IOException;
                    }
                    return false;
                };
                try {
                    Predicates.await((BooleanSupplier)condition, (long)2L, (TimeUnit)TimeUnit.SECONDS);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("Eventually Disconnects");
            }
        };
    }
}

