/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.io.IOException;
import java.util.Collections;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.AbstractBoltTransportsTest;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.example.Edges;
import org.neo4j.bolt.v1.messaging.example.Nodes;
import org.neo4j.bolt.v1.messaging.example.Paths;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.PathValue;

public class UnsupportedStructTypesV1V2IT
extends AbstractBoltTransportsTest {
    private static final String USER_AGENT = "TestClient/1.0";
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));

    @Before
    public void setup() throws Exception {
        this.address = this.server.lookupDefaultConnector();
    }

    @Test
    public void shouldFailWhenNullKeyIsSentWithInit() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(64, new byte[][]{this.createMsgWithNullKey(BoltRequestMessage.INIT.signature())}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string.")));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailWhenDuplicateKeyIsSentWithInit() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(64, new byte[][]{this.createMsgWithDuplicateKey(BoltRequestMessage.INIT.signature())}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Request.Invalid, "Duplicate map key `key1`.")));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailWhenNullKeyIsSentWithRun() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.connection.send(this.util.chunk(64, new byte[][]{this.createMsgWithNullKey(BoltRequestMessage.RUN.signature())}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string.")));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailWhenDuplicateKeyIsSentWithRun() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.connection.send(this.util.chunk(64, new byte[][]{this.createMsgWithDuplicateKey(BoltRequestMessage.RUN.signature())}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Request.Invalid, "Duplicate map key `key1`.")));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldFailWhenNodeIsSentWithRun() throws Exception {
        this.testFailureWithV1Value((AnyValue)Nodes.ALICE, "Node");
    }

    @Test
    public void shouldFailWhenRelationshipIsSentWithRun() throws Exception {
        this.testFailureWithV1Value((AnyValue)Edges.ALICE_KNOWS_BOB, "Relationship");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailWhenPathIsSentWithRun() throws Exception {
        for (PathValue path : Paths.ALL_PATHS) {
            try {
                this.testFailureWithV1Value((AnyValue)path, "Path");
            }
            finally {
                this.reconnect();
            }
        }
    }

    @Test
    public void shouldTerminateConnectionWhenUnknownMessageIsSent() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.connection.send(this.util.chunk(64, new byte[][]{this.createMsg((byte)65)}));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldTerminateConnectionWhenUnknownTypeIsSent() throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.connection.send(this.util.chunk(64, new byte[][]{this.createMsgWithUnknownValue(BoltRequestMessage.RUN.signature())}));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    private void testFailureWithV1Value(AnyValue value, String description) throws Exception {
        this.connection.connect(this.address).send(this.util.defaultAcceptedVersions());
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceivesSelectedProtocolVersion());
        this.connection.send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess()));
        this.connection.send(this.util.chunk(64, new byte[][]{this.createRunWithV1Value(value)}));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgFailure((Status)Status.Statement.TypeError, description + " values cannot be unpacked with this version of bolt.")));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyDisconnects());
    }

    private byte[] createRunWithV1Value(AnyValue value) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, BoltRequestMessage.RUN.signature());
        packer.pack("RETURN $x");
        packer.packMapHeader(1);
        packer.pack("x");
        packer.pack(value);
        return out.bytes();
    }

    private byte[] createMsg(byte signature) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(0, signature);
        return out.bytes();
    }

    private byte[] createMsgWithNullKey(byte signature) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, signature);
        packer.pack("Text");
        UnsupportedStructTypesV1V2IT.packMapWithNullKey(packer);
        return out.bytes();
    }

    private byte[] createMsgWithDuplicateKey(byte signature) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, signature);
        packer.pack("Text");
        UnsupportedStructTypesV1V2IT.packMapWithDuplicateKey(packer);
        return out.bytes();
    }

    private byte[] createMsgWithUnknownValue(byte signature) throws IOException {
        PackedOutputArray out = new PackedOutputArray();
        Neo4jPack.Packer packer = this.neo4jPack.newPacker((PackOutput)out);
        packer.packStructHeader(2, signature);
        packer.pack("Text");
        packer.packMapHeader(1);
        packer.pack("key1");
        packer.packStructHeader(0, (byte)65);
        return out.bytes();
    }

    private static void packMapWithNullKey(Neo4jPack.Packer packer) throws IOException {
        packer.packMapHeader(2);
        packer.pack("key1");
        packer.pack(ValueUtils.of(null));
        packer.pack(ValueUtils.of(null));
        packer.pack("value1");
    }

    private static void packMapWithDuplicateKey(Neo4jPack.Packer packer) throws IOException {
        packer.packMapHeader(2);
        packer.pack("key1");
        packer.pack("value1");
        packer.pack("key1");
        packer.pack("value2");
    }
}

