/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.bolt.v1.transport.ChunkedOutput;

public class ChunkedOutputTest {
    private static final int DEFAULT_TEST_BUFFER_SIZE = 16;
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private ChunkedOutput out;

    @Before
    public void setUp() {
        this.out = new ChunkedOutput((Channel)this.channel, 16, 16, TransportThrottleGroup.NO_THROTTLE);
    }

    @After
    public void tearDown() {
        this.out.close();
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldFlushNothingWhenEmpty() throws Exception {
        this.out.flush();
        Assert.assertEquals((long)0L, (long)this.channel.outboundMessages().size());
    }

    @Test
    public void shouldFlushNothingWhenClosed() throws Exception {
        this.out.close();
        this.out.flush();
        Assert.assertEquals((long)0L, (long)this.channel.outboundMessages().size());
    }

    @Test
    public void shouldWriteAndFlushByte() throws Exception {
        this.out.beginMessage();
        this.out.writeByte((byte)42);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining((byte)42) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteAndFlushShort() throws Exception {
        this.out.beginMessage();
        this.out.writeShort((short)42);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining((short)42) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteAndFlushInt() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(424242);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(424242) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteAndFlushLong() throws Exception {
        this.out.beginMessage();
        this.out.writeLong(42424242L);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(42424242L) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteAndFlushDouble() throws Exception {
        this.out.beginMessage();
        this.out.writeDouble(42.4224);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(42.4224) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteAndFlushByteBuffer() throws Exception {
        this.out.beginMessage();
        this.out.writeBytes(ByteBuffer.wrap(new byte[]{9, 8, 7, 6, 5, 4, 3, 2, 1}));
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining((byte)9, (byte)8, (byte)7, (byte)6, (byte)5, (byte)4, (byte)3, (byte)2, (byte)1) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteAndFlushByteArray() throws Exception {
        this.out.beginMessage();
        this.out.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, 1, 5);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining((byte)2, (byte)3, (byte)4, (byte)5, (byte)6) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldThrowWhenByteArrayContainsInsufficientBytes() throws Exception {
        try {
            this.out.writeBytes(new byte[]{1, 2, 3}, 1, 5);
            Assert.fail((String)"Exception expected");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Asked to write 5 bytes, but there is only 2 bytes available in data provided.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldFlushOnClose() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(42).writeInt(4242).writeInt(424242);
        this.out.messageSucceeded();
        this.out.close();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(42, 4242, 424242) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldCloseNothingWhenAlreadyClosed() throws Exception {
        this.out.beginMessage();
        this.out.writeLong(42L);
        this.out.messageSucceeded();
        this.out.close();
        this.out.close();
        this.out.close();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(42L) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldChunkSingleMessage() throws Throwable {
        this.out.beginMessage();
        this.out.writeByte((byte)1);
        this.out.writeShort((short)2);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining((byte)1, (short)2) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldChunkMessageSpanningMultipleChunks() throws Throwable {
        this.out.beginMessage();
        this.out.writeLong(1L);
        this.out.writeLong(2L);
        this.out.writeLong(3L);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(1L) + ChunkedOutputTest.chunkContaining(2L) + ChunkedOutputTest.chunkContaining(3L) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldChunkDataWhoseSizeIsGreaterThanOutputBufferCapacity() throws IOException {
        this.out.beginMessage();
        byte[] bytes = new byte[16];
        Arrays.fill(bytes, (byte)42);
        this.out.writeBytes(bytes, 0, 16);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        Object[] chunk1Body = new Number[14];
        Arrays.fill(chunk1Body, (Object)42);
        Object[] chunk2Body = new Number[2];
        Arrays.fill(chunk2Body, (Object)42);
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining((Number[])chunk1Body) + ChunkedOutputTest.chunkContaining((Number[])chunk2Body) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldNotThrowIfOutOfSyncFlush() throws Throwable {
        this.out.beginMessage();
        this.out.writeLong(1L);
        this.out.writeLong(2L);
        this.out.writeLong(3L);
        this.out.messageSucceeded();
        this.out.flush();
        this.out.close();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(1L) + ChunkedOutputTest.chunkContaining(2L) + ChunkedOutputTest.chunkContaining(3L) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldNotBeAbleToWriteAfterClose() throws Throwable {
        this.out.beginMessage();
        this.out.writeLong(1L);
        this.out.writeLong(2L);
        this.out.writeLong(3L);
        this.out.messageSucceeded();
        this.out.flush();
        this.out.close();
        try {
            this.out.writeShort((short)42);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowErrorWithRemoteAddressWhenClosed() throws Exception {
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Mockito.when((Object)allocator.buffer(ArgumentMatchers.anyInt())).thenReturn((Object)Unpooled.buffer());
        Mockito.when((Object)channel.alloc()).thenReturn((Object)allocator);
        SocketAddress remoteAddress = (SocketAddress)Mockito.mock(SocketAddress.class);
        String remoteAddressString = "client.server.com:7687";
        Mockito.when((Object)remoteAddress.toString()).thenReturn((Object)remoteAddressString);
        Mockito.when((Object)channel.remoteAddress()).thenReturn((Object)remoteAddress);
        ChunkedOutput output = new ChunkedOutput(channel, 16, 16, TransportThrottleGroup.NO_THROTTLE);
        output.close();
        try {
            output.writeInt(42);
            Assert.fail((String)"Exception expected");
        }
        catch (PackOutputClosedException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)remoteAddressString));
        }
    }

    @Test
    public void shouldTruncateFailedMessage() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(1);
        this.out.writeInt(2);
        this.out.messageSucceeded();
        this.out.beginMessage();
        this.out.writeInt(3);
        this.out.writeInt(4);
        this.out.messageFailed();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(1, 2) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldAllowWritingAfterFailedMessage() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(1);
        this.out.writeInt(2);
        this.out.messageSucceeded();
        this.out.beginMessage();
        this.out.writeByte((byte)3);
        this.out.writeByte((byte)4);
        this.out.messageFailed();
        this.out.beginMessage();
        this.out.writeInt(33);
        this.out.writeLong(44L);
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(1, 2) + ChunkedOutputTest.messageBoundary() + ChunkedOutputTest.chunkContaining(33, 44L) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldWriteOnlyMessageBoundaryWhenWriterIsEmpty() throws Exception {
        this.out.beginMessage();
        this.out.messageSucceeded();
        this.out.flush();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldAutoFlushOnlyWhenMaxBufferSizeReachedAfterFullMessage() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(1);
        this.out.writeInt(2);
        this.out.writeInt(3);
        this.out.writeLong(4L);
        Assert.assertEquals((long)0L, (long)this.peekAllOutboundMessages().size());
        this.out.writeByte((byte)5);
        this.out.writeByte((byte)6);
        this.out.writeLong(7L);
        this.out.writeInt(8);
        this.out.writeByte((byte)9);
        Assert.assertEquals((long)0L, (long)this.peekAllOutboundMessages().size());
        this.out.messageSucceeded();
        ByteBuf outboundMessage = this.peekSingleOutboundMessage();
        ChunkedOutputTest.assertByteBufEqual(outboundMessage, ChunkedOutputTest.chunkContaining(1, 2, 3) + ChunkedOutputTest.chunkContaining(4L, (byte)5, (byte)6) + ChunkedOutputTest.chunkContaining(7L, 8, (byte)9) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldAutoFlushMultipleMessages() throws Exception {
        this.out.beginMessage();
        this.out.writeLong(1L);
        this.out.writeLong(2L);
        this.out.messageSucceeded();
        this.out.beginMessage();
        this.out.writeLong(3L);
        this.out.writeLong(4L);
        this.out.messageSucceeded();
        this.out.beginMessage();
        this.out.writeLong(5L);
        this.out.writeLong(6L);
        this.out.messageSucceeded();
        List<ByteBuf> outboundMessages = this.peekAllOutboundMessages();
        Assert.assertEquals((long)3L, (long)outboundMessages.size());
        ChunkedOutputTest.assertByteBufEqual(outboundMessages.get(0), ChunkedOutputTest.chunkContaining(1L) + ChunkedOutputTest.chunkContaining(2L) + ChunkedOutputTest.messageBoundary());
        ChunkedOutputTest.assertByteBufEqual(outboundMessages.get(1), ChunkedOutputTest.chunkContaining(3L) + ChunkedOutputTest.chunkContaining(4L) + ChunkedOutputTest.messageBoundary());
        ChunkedOutputTest.assertByteBufEqual(outboundMessages.get(2), ChunkedOutputTest.chunkContaining(5L) + ChunkedOutputTest.chunkContaining(6L) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldFailToBeginMultipleMessages() {
        this.out.beginMessage();
        try {
            this.out.beginMessage();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToMarkMessageAsSuccessfulWhenMessageNotStarted() throws Exception {
        try {
            this.out.messageSucceeded();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToMarkMessageAsFialedWhenMessageNotStarted() throws Exception {
        try {
            this.out.messageFailed();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteByteOutsideOfMessage() throws Exception {
        try {
            this.out.writeByte((byte)1);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteShortOutsideOfMessage() throws Exception {
        try {
            this.out.writeShort((short)1);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteIntOutsideOfMessage() throws Exception {
        try {
            this.out.writeInt(1);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteLongOutsideOfMessage() throws Exception {
        try {
            this.out.writeLong(1L);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteDoubleOutsideOfMessage() throws Exception {
        try {
            this.out.writeDouble(1.1);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToWriteBytesOutsideOfMessage() throws Exception {
        try {
            this.out.writeBytes(ByteBuffer.wrap(new byte[10]));
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToMarkMessageAsSuccessfulAndThenAsFailed() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(42);
        this.out.messageSucceeded();
        try {
            this.out.messageFailed();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.out.flush();
        ChunkedOutputTest.assertByteBufEqual(this.peekSingleOutboundMessage(), ChunkedOutputTest.chunkContaining(42) + ChunkedOutputTest.messageBoundary());
    }

    @Test
    public void shouldFailToMarkMessageAsFailedAndThenAsSuccessful() throws Exception {
        this.out.beginMessage();
        this.out.writeInt(42);
        this.out.messageFailed();
        try {
            this.out.messageSucceeded();
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.out.flush();
        Assert.assertEquals((long)0L, (long)this.peekAllOutboundMessages().size());
    }

    @Test
    public void shouldAllowMultipleFailedMessages() throws Exception {
        for (int i = 0; i < 7; ++i) {
            this.out.beginMessage();
            this.out.writeByte((byte)i);
            this.out.writeShort((short)i);
            this.out.writeInt(i);
            this.out.messageFailed();
        }
        this.out.flush();
        Assert.assertEquals((long)0L, (long)this.peekAllOutboundMessages().size());
        this.out.beginMessage();
        this.out.writeByte((byte)8);
        this.out.writeShort((short)9);
        this.out.writeInt(10);
        this.out.writeDouble(199.92);
        this.out.messageSucceeded();
        ChunkedOutputTest.assertByteBufEqual(this.peekSingleOutboundMessage(), ChunkedOutputTest.chunkContaining((byte)8, (short)9, 10) + ChunkedOutputTest.chunkContaining(199.92) + ChunkedOutputTest.messageBoundary());
    }

    private ByteBuf peekSingleOutboundMessage() {
        List<ByteBuf> outboundMessages = this.peekAllOutboundMessages();
        Assert.assertEquals((long)1L, (long)outboundMessages.size());
        return outboundMessages.get(0);
    }

    private List<ByteBuf> peekAllOutboundMessages() {
        return this.channel.outboundMessages().stream().map(msg -> (ByteBuf)msg).collect(Collectors.toList());
    }

    private static void assertByteBufEqual(ByteBuf buf, String hexContent) {
        Assert.assertEquals((Object)ByteBufUtil.hexDump((ByteBuf)buf), (Object)hexContent);
    }

    private static String chunkContaining(Number ... values) {
        short chunkSize = 0;
        for (Number value : values) {
            if (value instanceof Byte) {
                chunkSize = (short)(chunkSize + 1);
                continue;
            }
            if (value instanceof Short) {
                chunkSize = (short)(chunkSize + 2);
                continue;
            }
            if (value instanceof Integer) {
                chunkSize = (short)(chunkSize + 4);
                continue;
            }
            if (value instanceof Long) {
                chunkSize = (short)(chunkSize + 8);
                continue;
            }
            if (value instanceof Double) {
                chunkSize = (short)(chunkSize + 8);
                continue;
            }
            throw new IllegalArgumentException("Unsupported number " + value.getClass() + ' ' + value);
        }
        ByteBuffer buffer = ByteBuffer.allocate(chunkSize + 2);
        buffer.putShort(chunkSize);
        for (Number value : values) {
            if (value instanceof Byte) {
                buffer.put(value.byteValue());
                continue;
            }
            if (value instanceof Short) {
                buffer.putShort(value.shortValue());
                continue;
            }
            if (value instanceof Integer) {
                buffer.putInt(value.intValue());
                continue;
            }
            if (value instanceof Long) {
                buffer.putLong(value.longValue());
                continue;
            }
            if (value instanceof Double) {
                buffer.putDouble(value.doubleValue());
                continue;
            }
            throw new IllegalArgumentException("Unsupported number " + value.getClass() + ' ' + value);
        }
        buffer.flip();
        return ByteBufUtil.hexDump((byte[])buffer.array());
    }

    private static String messageBoundary() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort((short)0);
        buffer.flip();
        return ByteBufUtil.hexDump((byte[])buffer.array());
    }
}

