/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.util.HexPrinter;

public class SocketConnection
implements TransportConnection {
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    public SocketConnection() {
        this(new Socket());
    }

    public SocketConnection(Socket socket) {
        this.socket = socket;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public TransportConnection connect(HostnamePort address) throws IOException {
        this.socket.setSoTimeout(30000000);
        this.socket.connect(new InetSocketAddress(address.getHost(), address.getPort()));
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        return this;
    }

    @Override
    public TransportConnection send(byte[] rawBytes) throws IOException {
        this.out.write(rawBytes);
        return this;
    }

    @Override
    public byte[] recv(int length) throws IOException {
        int left;
        byte[] bytes = new byte[length];
        try {
            int read;
            for (left = length; left > 0 && (read = this.in.read(bytes, length - left, left)) != -1; left -= read) {
            }
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException("Reading data timed out, missing " + left + " bytes. Buffer: " + HexPrinter.hex((byte[])bytes));
        }
        if (left != 0) {
            throw new IOException("Failed to read " + length + " bytes, missing " + left + " bytes. Buffer: " + HexPrinter.hex((byte[])bytes));
        }
        return bytes;
    }

    @Override
    public void disconnect() throws IOException {
        if (this.socket != null && this.socket.isConnected()) {
            this.socket.close();
        }
    }
}

