/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.impl.util.HexPrinter;

public class WebSocketConnection
implements TransportConnection,
WebSocketListener {
    private final Supplier<WebSocketClient> clientSupplier;
    private final Function<HostnamePort, URI> uriGenerator;
    private final byte[] POISON_PILL = "poison".getBytes();
    private WebSocketClient client;
    private RemoteEndpoint server;
    private final LinkedBlockingQueue<byte[]> received = new LinkedBlockingQueue();
    private byte[] currentReceiveBuffer;
    private int currentReceiveIndex;

    public WebSocketConnection() {
        this(WebSocketClient::new, address -> URI.create("ws://" + address.getHost() + ":" + address.getPort()));
    }

    public WebSocketConnection(Supplier<WebSocketClient> clientSupplier, Function<HostnamePort, URI> uriGenerator) {
        this.clientSupplier = clientSupplier;
        this.uriGenerator = uriGenerator;
    }

    WebSocketConnection(WebSocketClient client) {
        this(null, null);
        this.client = client;
    }

    @Override
    public TransportConnection connect(HostnamePort address) throws Exception {
        Session session;
        URI target = this.uriGenerator.apply(address);
        this.client = this.clientSupplier.get();
        this.client.start();
        try {
            session = (Session)this.client.connect((Object)this, target).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException("Failed to connect to the server within 10 seconds", e);
        }
        this.server = session.getRemote();
        return this;
    }

    @Override
    public TransportConnection send(byte[] rawBytes) throws IOException {
        ByteBuffer wrap = ByteBuffer.wrap(Arrays.copyOf(rawBytes, rawBytes.length));
        this.server.sendBytes(wrap);
        return this;
    }

    @Override
    public byte[] recv(int length) throws IOException, InterruptedException {
        int remaining = length;
        byte[] target = new byte[remaining];
        while (remaining > 0) {
            this.waitForReceivedData(length, remaining, target);
            for (int i = 0; i < Math.min(remaining, this.currentReceiveBuffer.length - this.currentReceiveIndex); ++i) {
                target[length - remaining] = this.currentReceiveBuffer[this.currentReceiveIndex++];
                --remaining;
            }
        }
        return target;
    }

    private void waitForReceivedData(int length, int remaining, byte[] target) throws InterruptedException, IOException {
        long start = System.currentTimeMillis();
        while (this.currentReceiveBuffer == null || this.currentReceiveIndex >= this.currentReceiveBuffer.length) {
            this.currentReceiveIndex = 0;
            this.currentReceiveBuffer = this.received.poll(10L, TimeUnit.MILLISECONDS);
            if (this.currentReceiveBuffer == null && (this.client.isStopped() || this.client.isStopping()) || this.currentReceiveBuffer == this.POISON_PILL) {
                throw new IOException("Connection closed while waiting for data from the server.");
            }
            if (System.currentTimeMillis() - start <= 30000L) continue;
            throw new IOException("Waited 30 seconds for " + remaining + " bytes, " + (length - remaining) + " was received: " + HexPrinter.hex((ByteBuffer)ByteBuffer.wrap(target), (int)0, (int)(length - remaining)));
        }
    }

    @Override
    public void disconnect() throws IOException {
        if (this.client != null) {
            try {
                this.client.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void onWebSocketBinary(byte[] bytes, int i, int i2) {
        this.received.add(bytes);
    }

    public void onWebSocketClose(int i, String s) {
        this.received.add(this.POISON_PILL);
    }

    public void onWebSocketConnect(Session session) {
    }

    public void onWebSocketError(Throwable throwable) {
    }

    public void onWebSocketText(String s) {
    }
}

