/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v2.messaging;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.bolt.v1.packstream.PackedOutputArray;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public class Neo4jPackV2Test {
    private static final String[] TIME_ZONE_NAMES = (String[])TimeZones.supportedTimeZones().stream().filter(s -> ZoneId.getAvailableZoneIds().contains(s)).toArray(String[]::new);
    private static final int RANDOM_VALUES_TO_TEST = 1000;
    private static final int RANDOM_LISTS_TO_TEST = 1000;
    private static final int RANDOM_LIST_MAX_SIZE = 500;

    @Test
    public void shouldFailToPackPointWithIllegalDimensions() {
        Neo4jPackV2Test.testPackingPointsWithWrongDimensions(0);
        Neo4jPackV2Test.testPackingPointsWithWrongDimensions(1);
        Neo4jPackV2Test.testPackingPointsWithWrongDimensions(4);
        Neo4jPackV2Test.testPackingPointsWithWrongDimensions(100);
    }

    @Test
    public void shouldFailToUnpack2DPointWithIncorrectCoordinate() throws IOException {
        Neo4jPackV2 neo4jPack = new Neo4jPackV2();
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)output);
        packer.packStructHeader(3, (byte)88);
        packer.pack((AnyValue)Values.intValue((int)CoordinateReferenceSystem.WGS84.getCode()));
        packer.pack((AnyValue)Values.doubleValue((double)42.42));
        try {
            Neo4jPackV2Test.unpack(output);
            Assert.fail((String)"Exception expected");
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldFailToUnpack3DPointWithIncorrectCoordinate() throws IOException {
        Neo4jPackV2 neo4jPack = new Neo4jPackV2();
        PackedOutputArray output = new PackedOutputArray();
        Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)output);
        packer.packStructHeader(4, (byte)89);
        packer.pack((AnyValue)Values.intValue((int)CoordinateReferenceSystem.Cartesian.getCode()));
        packer.pack((AnyValue)Values.doubleValue((double)1.0));
        packer.pack((AnyValue)Values.doubleValue((double)100.1));
        try {
            Neo4jPackV2Test.unpack(output);
            Assert.fail((String)"Exception expected");
        }
        catch (UncheckedIOException uncheckedIOException) {
            // empty catch block
        }
    }

    @Test
    public void shouldPackAndUnpack2DPoints() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomPoint2D);
    }

    @Test
    public void shouldPackAndUnpack3DPoints() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomPoint3D);
    }

    @Test
    public void shouldPackAndUnpackListsOf2DPoints() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomPoint2D));
    }

    @Test
    public void shouldPackAndUnpackListsOf3DPoints() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomPoint3D));
    }

    @Test
    public void shouldPackAndUnpackDuration() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomDuration);
    }

    @Test
    public void shouldPackAndUnpackListsOfDuration() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomDuration));
    }

    @Test
    public void shouldPackAndUnpackDate() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomDate);
    }

    @Test
    public void shouldPackAndUnpackListsOfDate() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomDate));
    }

    @Test
    public void shouldPackAndUnpackLocalTime() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomLocalTime);
    }

    @Test
    public void shouldPackAndUnpackListsOfLocalTime() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomLocalTime));
    }

    @Test
    public void shouldPackAndUnpackTime() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomTime);
    }

    @Test
    public void shouldPackAndUnpackListsOfTime() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomTime));
    }

    @Test
    public void shouldPackAndUnpackLocalDateTime() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomLocalDateTime);
    }

    @Test
    public void shouldPackAndUnpackListsOfLocalDateTime() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomLocalDateTime));
    }

    @Test
    public void shouldPackAndUnpackDateTimeWithTimeZoneName() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomDateTimeWithTimeZoneName);
    }

    @Test
    public void shouldPackAndUnpackListsOfDateTimeWithTimeZoneName() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomDateTimeWithTimeZoneName));
    }

    @Test
    public void shouldPackAndUnpackDateTimeWithTimeZoneOffset() {
        Neo4jPackV2Test.testPackingAndUnpacking(this::randomDateTimeWithTimeZoneOffset);
    }

    @Test
    public void shouldPackAndUnpackListsOfDateTimeWithTimeZoneOffset() {
        Neo4jPackV2Test.testPackingAndUnpacking(() -> Neo4jPackV2Test.randomList(this::randomDateTimeWithTimeZoneOffset));
    }

    @Test
    public void shouldPackLocalDateTimeWithTimeZoneOffset() {
        LocalDateTime localDateTime = LocalDateTime.of(2015, 3, 23, 19, 15, 59, 10);
        ZoneOffset offset = ZoneOffset.ofHoursMinutes(-5, -15);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, offset);
        PackedOutputArray packedOutput = Neo4jPackV2Test.pack((AnyValue)DateTimeValue.datetime((ZonedDateTime)zonedDateTime));
        ByteBuffer buffer = ByteBuffer.wrap(packedOutput.bytes());
        buffer.getShort();
        Assert.assertEquals((long)-54L, (long)buffer.get());
        Assert.assertEquals((long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)buffer.getInt());
        Assert.assertEquals((long)localDateTime.getNano(), (long)buffer.get());
        Assert.assertEquals((long)-55L, (long)buffer.get());
        Assert.assertEquals((long)offset.getTotalSeconds(), (long)buffer.getShort());
    }

    @Test
    public void shouldPackLocalDateTimeWithTimeZoneId() {
        LocalDateTime localDateTime = LocalDateTime.of(1999, 12, 30, 9, 49, 20, 999999999);
        ZoneId zoneId = ZoneId.of("Europe/Stockholm");
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, zoneId);
        PackedOutputArray packedOutput = Neo4jPackV2Test.pack((AnyValue)DateTimeValue.datetime((ZonedDateTime)zonedDateTime));
        ByteBuffer buffer = ByteBuffer.wrap(packedOutput.bytes());
        buffer.getShort();
        Assert.assertEquals((long)-54L, (long)buffer.get());
        Assert.assertEquals((long)localDateTime.toEpochSecond(ZoneOffset.UTC), (long)buffer.getInt());
        Assert.assertEquals((long)-54L, (long)buffer.get());
        Assert.assertEquals((long)localDateTime.getNano(), (long)buffer.getInt());
        buffer.getShort();
        byte[] zoneIdBytes = new byte[zoneId.getId().getBytes(StandardCharsets.UTF_8).length];
        buffer.get(zoneIdBytes);
        Assert.assertEquals((Object)zoneId.getId(), (Object)new String(zoneIdBytes, StandardCharsets.UTF_8));
    }

    private static <T extends AnyValue> void testPackingAndUnpacking(Supplier<T> randomValueGenerator) {
        Neo4jPackV2Test.testPackingAndUnpacking((Integer index) -> (AnyValue)randomValueGenerator.get());
    }

    private static <T extends AnyValue> void testPackingAndUnpacking(Function<Integer, T> randomValueGenerator) {
        IntStream.range(0, 1000).mapToObj(randomValueGenerator::apply).forEach(originalValue -> {
            AnyValue unpackedValue = Neo4jPackV2Test.packAndUnpack(originalValue);
            Assert.assertEquals((Object)originalValue, (Object)unpackedValue);
        });
    }

    private static void testPackingPointsWithWrongDimensions(int dimensions) {
        PointValue point = Neo4jPackV2Test.randomPoint(0, dimensions);
        try {
            Neo4jPackV2Test.pack((AnyValue)point);
            Assert.fail((String)"Exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static <T extends AnyValue> T packAndUnpack(T value) {
        return Neo4jPackV2Test.unpack(Neo4jPackV2Test.pack(value));
    }

    private static PackedOutputArray pack(AnyValue value) {
        try {
            Neo4jPackV2 neo4jPack = new Neo4jPackV2();
            PackedOutputArray output = new PackedOutputArray();
            Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)output);
            packer.pack(value);
            return output;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T extends AnyValue> T unpack(PackedOutputArray output) {
        try {
            Neo4jPackV2 neo4jPack = new Neo4jPackV2();
            PackedInputArray input = new PackedInputArray(output.bytes());
            Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)input);
            AnyValue unpack = unpacker.unpack();
            return (T)unpack;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T extends AnyValue> ListValue randomList(Supplier<T> randomValueGenerator) {
        return Neo4jPackV2Test.randomList((Integer index) -> (AnyValue)randomValueGenerator.get());
    }

    private static <T extends AnyValue> ListValue randomList(Function<Integer, T> randomValueGenerator) {
        AnyValue[] values = (AnyValue[])Neo4jPackV2Test.random().ints(1000L, 1, 500).mapToObj(index -> (AnyValue)randomValueGenerator.apply(index)).toArray(AnyValue[]::new);
        return VirtualValues.list((AnyValue[])values);
    }

    private PointValue randomPoint2D(int index) {
        return Neo4jPackV2Test.randomPoint(index, 2);
    }

    private PointValue randomPoint3D(int index) {
        return Neo4jPackV2Test.randomPoint(index, 3);
    }

    private static PointValue randomPoint(int index, int dimension) {
        CoordinateReferenceSystem crs = index % 2 == 0 ? (dimension == 2 ? CoordinateReferenceSystem.WGS84 : CoordinateReferenceSystem.WGS84_3D) : (dimension == 2 ? CoordinateReferenceSystem.Cartesian : CoordinateReferenceSystem.Cartesian_3D);
        return Values.unsafePointValue((CoordinateReferenceSystem)crs, (double[])Neo4jPackV2Test.random().doubles(dimension, Double.MIN_VALUE, Double.MAX_VALUE).toArray());
    }

    private DurationValue randomDuration(int index) {
        return DurationValue.duration((long)Neo4jPackV2Test.randomLong(index), (long)Neo4jPackV2Test.randomLong(index), (long)Neo4jPackV2Test.randomLong(index), (long)Neo4jPackV2Test.randomLong(index));
    }

    private DateValue randomDate() {
        return DateValue.epochDate((long)Neo4jPackV2Test.random(ChronoField.EPOCH_DAY));
    }

    private LocalTimeValue randomLocalTime() {
        return LocalTimeValue.localTime((long)Neo4jPackV2Test.random(ChronoField.NANO_OF_DAY));
    }

    private TimeValue randomTime() {
        return TimeValue.time((long)Neo4jPackV2Test.random(ChronoField.NANO_OF_DAY), (ZoneOffset)Neo4jPackV2Test.randomZoneOffset());
    }

    private LocalDateTimeValue randomLocalDateTime() {
        return LocalDateTimeValue.localDateTime((int)Neo4jPackV2Test.random(ChronoField.YEAR), (int)Neo4jPackV2Test.random(ChronoField.MONTH_OF_YEAR), (int)Neo4jPackV2Test.random(ChronoField.DAY_OF_MONTH), (int)Neo4jPackV2Test.random(ChronoField.HOUR_OF_DAY), (int)Neo4jPackV2Test.random(ChronoField.MINUTE_OF_HOUR), (int)Neo4jPackV2Test.random(ChronoField.SECOND_OF_MINUTE), (int)Neo4jPackV2Test.random(ChronoField.NANO_OF_SECOND));
    }

    private DateTimeValue randomDateTimeWithTimeZoneName() {
        return DateTimeValue.datetime((int)Neo4jPackV2Test.random(ChronoField.YEAR), (int)Neo4jPackV2Test.random(ChronoField.MONTH_OF_YEAR), (int)Neo4jPackV2Test.random(ChronoField.DAY_OF_MONTH), (int)Neo4jPackV2Test.random(ChronoField.HOUR_OF_DAY), (int)Neo4jPackV2Test.random(ChronoField.MINUTE_OF_HOUR), (int)Neo4jPackV2Test.random(ChronoField.SECOND_OF_MINUTE), (int)Neo4jPackV2Test.random(ChronoField.NANO_OF_SECOND), (ZoneId)Neo4jPackV2Test.randomZoneIdWithName());
    }

    private DateTimeValue randomDateTimeWithTimeZoneOffset() {
        return DateTimeValue.datetime((int)Neo4jPackV2Test.random(ChronoField.YEAR), (int)Neo4jPackV2Test.random(ChronoField.MONTH_OF_YEAR), (int)Neo4jPackV2Test.random(ChronoField.DAY_OF_MONTH), (int)Neo4jPackV2Test.random(ChronoField.HOUR_OF_DAY), (int)Neo4jPackV2Test.random(ChronoField.MINUTE_OF_HOUR), (int)Neo4jPackV2Test.random(ChronoField.SECOND_OF_MINUTE), (int)Neo4jPackV2Test.random(ChronoField.NANO_OF_SECOND), (ZoneId)Neo4jPackV2Test.randomZoneOffset());
    }

    private static long randomLong(long origin) {
        return Neo4jPackV2Test.random().nextLong(origin, Long.MAX_VALUE);
    }

    private static int random(ChronoField chronoField) {
        ValueRange range = chronoField.range();
        int min = (int)range.getMinimum();
        int max = (int)range.getSmallestMaximum();
        if ((long)max != range.getSmallestMaximum()) {
            max = Integer.MAX_VALUE;
        }
        return Neo4jPackV2Test.random().nextInt(min, max);
    }

    private static ZoneOffset randomZoneOffset() {
        return ZoneOffset.ofTotalSeconds(Neo4jPackV2Test.random().nextInt(ZoneOffset.MIN.getTotalSeconds(), ZoneOffset.MAX.getTotalSeconds() + 1));
    }

    private static ZoneId randomZoneIdWithName() {
        String timeZoneName = TIME_ZONE_NAMES[Neo4jPackV2Test.random().nextInt(TIME_ZONE_NAMES.length)];
        return ZoneId.of(timeZoneName);
    }

    private static ThreadLocalRandom random() {
        return ThreadLocalRandom.current();
    }
}

