/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v2.transport.integration;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

@RunWith(value=Parameterized.class)
public class BoltV2TransportIT {
    private static final String USER_AGENT = "TestClient/2.0";
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "false"));
    @Parameterized.Parameter
    public Class<? extends TransportConnection> connectionClass;
    private HostnamePort address;
    private TransportConnection connection;
    private TransportTestUtil util;

    @Parameterized.Parameters(name="{0}")
    public static List<Class<? extends TransportConnection>> transports() {
        return Arrays.asList(SocketConnection.class, WebSocketConnection.class, SecureSocketConnection.class, SecureWebSocketConnection.class);
    }

    @Before
    public void setUp() throws Exception {
        this.address = this.server.lookupDefaultConnector();
        this.connection = this.connectionClass.newInstance();
        this.util = new TransportTestUtil((Neo4jPack)new Neo4jPackV2());
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void shouldNegotiateProtocolV2() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(2L, 0L, 0L, 0L)).send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 2}));
    }

    @Test
    public void shouldNegotiateProtocolV2WhenClientSupportsBothV1AndV2() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(2L, 1L, 0L, 0L)).send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 2}));
    }

    @Test
    public void shouldSendPoint2D() throws Exception {
        this.testSendingOfBoltV2Value(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{39.111748, -76.775635}));
    }

    @Test
    public void shouldReceivePoint2D() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN point({x: 40.7624, y: 73.9738})", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{40.7624, 73.9738}));
    }

    @Test
    public void shouldSendAndReceivePoint2D() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{38.8719, 77.0563}));
    }

    @Test
    public void shouldSendDuration() throws Exception {
        this.testSendingOfBoltV2Value(DurationValue.duration((long)5L, (long)3L, (long)34L, (long)0L));
    }

    @Test
    public void shouldReceiveDuration() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN duration({months: 3, days: 100, seconds: 999, nanoseconds: 42})", DurationValue.duration((long)3L, (long)100L, (long)999L, (long)42L));
    }

    @Test
    public void shouldSendAndReceiveDuration() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(DurationValue.duration((long)17L, (long)9L, (long)2L, (long)1000000L));
    }

    @Test
    public void shouldSendDate() throws Exception {
        this.testSendingOfBoltV2Value(DateValue.date((int)1991, (int)8, (int)24));
    }

    @Test
    public void shouldReceiveDate() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN date('2015-02-18')", DateValue.date((int)2015, (int)2, (int)18));
    }

    @Test
    public void shouldSendAndReceiveDate() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(DateValue.date((int)2005, (int)5, (int)22));
    }

    @Test
    public void shouldSendLocalTime() throws Exception {
        this.testSendingOfBoltV2Value(LocalTimeValue.localTime((int)2, (int)35, (int)10, (int)1));
    }

    @Test
    public void shouldReceiveLocalTime() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN localtime('11:04:35')", LocalTimeValue.localTime((int)11, (int)4, (int)35, (int)0));
    }

    @Test
    public void shouldSendAndReceiveLocalTime() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(LocalTimeValue.localTime((int)22, (int)10, (int)10, (int)99));
    }

    @Test
    public void shouldSendTime() throws Exception {
        this.testSendingOfBoltV2Value(TimeValue.time((long)424242L, (ZoneOffset)ZoneOffset.of("+08:30")));
    }

    @Test
    public void shouldReceiveTime() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN time('14:30+0100')", TimeValue.time((int)14, (int)30, (int)0, (int)0, (ZoneOffset)ZoneOffset.ofHours(1)));
    }

    @Test
    public void shouldSendAndReceiveTime() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(TimeValue.time((int)19, (int)22, (int)44, (int)100, (ZoneOffset)ZoneOffset.ofHours(-5)));
    }

    @Test
    public void shouldSendLocalDateTime() throws Exception {
        this.testSendingOfBoltV2Value(LocalDateTimeValue.localDateTime((int)2002, (int)5, (int)22, (int)15, (int)15, (int)25, (int)0));
    }

    @Test
    public void shouldReceiveLocalDateTime() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN localdatetime('20150202T19:32:24')", LocalDateTimeValue.localDateTime((int)2015, (int)2, (int)2, (int)19, (int)32, (int)24, (int)0));
    }

    @Test
    public void shouldSendAndReceiveLocalDateTime() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(LocalDateTimeValue.localDateTime((int)1995, (int)12, (int)12, (int)10, (int)30, (int)0, (int)0));
    }

    @Test
    public void shouldSendDateTimeWithTimeZoneName() throws Exception {
        this.testSendingOfBoltV2Value(DateTimeValue.datetime((int)1956, (int)9, (int)14, (int)11, (int)20, (int)25, (int)0, (String)"Europe/Stockholm"));
    }

    @Test
    public void shouldReceiveDateTimeWithTimeZoneName() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN datetime({year:1984, month:10, day:11, hour:21, minute:30, timezone:'Europe/London'})", DateTimeValue.datetime((int)1984, (int)10, (int)11, (int)21, (int)30, (int)0, (int)0, (String)"Europe/London"));
    }

    @Test
    public void shouldSendAndReceiveDateTimeWithTimeZoneName() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(DateTimeValue.datetime((int)1984, (int)10, (int)11, (int)21, (int)30, (int)0, (int)0, (String)"Europe/London"));
    }

    @Test
    public void shouldSendDateTimeWithTimeZoneOffset() throws Exception {
        this.testSendingOfBoltV2Value(DateTimeValue.datetime((long)424242L, (long)0L, (ZoneOffset)ZoneOffset.ofHoursMinutes(-7, -15)));
    }

    @Test
    public void shouldReceiveDateTimeWithTimeZoneOffset() throws Exception {
        this.testReceivingOfBoltV2Value("RETURN datetime({year:2022, month:3, day:2, hour:19, minute:10, timezone:'+02:30'})", DateTimeValue.datetime((int)2022, (int)3, (int)2, (int)19, (int)10, (int)0, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(2, 30)));
    }

    @Test
    public void shouldSendAndReceiveDateTimeWithTimeZoneOffset() throws Exception {
        this.testSendingAndReceivingOfBoltV2Value(DateTimeValue.datetime((int)1899, (int)1, (int)1, (int)12, (int)12, (int)32, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(-4, -15)));
    }

    private <T extends AnyValue> void testSendingOfBoltV2Value(T value) throws Exception {
        this.negotiateBoltV2();
        this.connection.send(this.util.chunk(RunMessage.run("CREATE (n:Node {value: $value}) RETURN 42", VirtualValues.map(Collections.singletonMap("value", value))), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo((Object)Values.longValue((long)42L)))), MessageMatchers.msgSuccess()));
    }

    private <T extends AnyValue> void testReceivingOfBoltV2Value(String query, T expectedValue) throws Exception {
        this.negotiateBoltV2();
        this.connection.send(this.util.chunk(RunMessage.run(query), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo(expectedValue))), MessageMatchers.msgSuccess()));
    }

    private <T extends AnyValue> void testSendingAndReceivingOfBoltV2Value(T value) throws Exception {
        this.negotiateBoltV2();
        this.connection.send(this.util.chunk(RunMessage.run("RETURN $value", VirtualValues.map(Collections.singletonMap("value", value))), PullAllMessage.pullAll()));
        MatcherAssert.assertThat((Object)this.connection, this.util.eventuallyReceives(MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess(), MessageMatchers.msgRecord(StreamMatchers.eqRecord(CoreMatchers.equalTo(value))), MessageMatchers.msgSuccess()));
    }

    private void negotiateBoltV2() throws Exception {
        this.connection.connect(this.address).send(this.util.acceptedVersions(2L, 0L, 0L, 0L)).send(this.util.chunk(InitMessage.init(USER_AGENT, Collections.emptyMap())));
        MatcherAssert.assertThat((Object)this.connection, TransportTestUtil.eventuallyReceives(new byte[]{0, 0, 0, 2}));
    }
}

