/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltScheduler;
import org.neo4j.bolt.runtime.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.ExecutorBoltScheduler;
import org.neo4j.bolt.runtime.ExecutorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

public class ExecutorBoltSchedulerProvider
extends LifecycleAdapter
implements BoltSchedulerProvider {
    private final Config config;
    private final ExecutorFactory executorFactory;
    private final JobScheduler scheduler;
    private final LogService logService;
    private final Log internalLog;
    private final ConcurrentHashMap<String, BoltScheduler> boltSchedulers;
    private ExecutorService forkJoinThreadPool;

    public ExecutorBoltSchedulerProvider(Config config, ExecutorFactory executorFactory, JobScheduler scheduler, LogService logService) {
        this.config = config;
        this.executorFactory = executorFactory;
        this.scheduler = scheduler;
        this.logService = logService;
        this.internalLog = logService.getInternalLog(this.getClass());
        this.boltSchedulers = new ConcurrentHashMap();
    }

    public void start() {
        this.forkJoinThreadPool = new ForkJoinPool();
        this.config.enabledBoltConnectors().forEach(connector -> {
            ExecutorBoltScheduler boltScheduler = new ExecutorBoltScheduler(connector.key(), this.executorFactory, this.scheduler, this.logService, (Integer)this.config.get(connector.thread_pool_min_size), (Integer)this.config.get(connector.thread_pool_max_size), (Duration)this.config.get(connector.thread_pool_keep_alive), (Integer)this.config.get(connector.unsupported_thread_pool_queue_size), this.forkJoinThreadPool);
            boltScheduler.start();
            this.boltSchedulers.put(connector.key(), boltScheduler);
        });
    }

    public void stop() {
        this.boltSchedulers.values().forEach(this::stopScheduler);
        this.boltSchedulers.clear();
        this.forkJoinThreadPool.shutdown();
        this.forkJoinThreadPool = null;
    }

    private void stopScheduler(BoltScheduler scheduler) {
        try {
            scheduler.stop();
        }
        catch (Throwable t) {
            this.internalLog.warn(String.format("An unexpected error occurred while stopping BoltScheduler [%s]", scheduler.connector()), t);
        }
    }

    @Override
    public BoltScheduler get(BoltChannel channel) {
        BoltScheduler boltScheduler = this.boltSchedulers.get(channel.connector());
        if (boltScheduler == null) {
            throw new IllegalArgumentException(String.format("Provided channel instance [local: %s, remote: %s] is not bound to any known bolt listen addresses.", channel.serverAddress(), channel.clientAddress()));
        }
        return boltScheduler;
    }
}

