/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v1.messaging.BoltMessageRouter;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.kernel.impl.logging.LogService;

public class DefaultBoltProtocolPipelineInstaller
implements BoltProtocolPipelineInstaller {
    private final BoltChannel boltChannel;
    private final Neo4jPack neo4jPack;
    private final BoltResponseMessageWriter responseWriter;
    private final BoltRequestMessageHandler messageHandler;
    private final LogService logging;
    private final BoltConnection connection;

    public DefaultBoltProtocolPipelineInstaller(BoltChannel boltChannel, BoltConnection connection, Neo4jPack neo4jPack, TransportThrottleGroup throttleGroup, LogService logging) {
        this.boltChannel = boltChannel;
        this.connection = connection;
        this.neo4jPack = neo4jPack;
        this.responseWriter = new BoltResponseMessageWriter(neo4jPack, connection.output(), logging, boltChannel.log());
        this.messageHandler = new BoltMessageRouter(logging.getInternalLog(this.getClass()), boltChannel.log(), connection, this.responseWriter);
        this.logging = logging;
    }

    @Override
    public void install() {
        ChannelPipeline pipeline = this.boltChannel.rawChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new ChunkDecoder()});
        pipeline.addLast(new ChannelHandler[]{new MessageAccumulator()});
        pipeline.addLast(new ChannelHandler[]{new MessageDecoder(this.neo4jPack, this.messageHandler, this.logging)});
        pipeline.addLast(new ChannelHandler[]{new HouseKeeper(this.connection, this.logging.getInternalLog(HouseKeeper.class))});
    }

    @Override
    public long version() {
        return this.neo4jPack.version();
    }
}

