/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

public enum BoltResponseMessage {
    SUCCESS(112),
    RECORD(113),
    IGNORED(126),
    FAILURE(127);

    private static BoltResponseMessage[] valuesBySignature;
    private final byte signature;

    public static BoltResponseMessage withSignature(int signature) {
        BoltResponseMessage message = valuesBySignature[signature];
        if (message == null) {
            throw new IllegalArgumentException(String.format("No message with signature %d", signature));
        }
        return message;
    }

    private BoltResponseMessage(int signature) {
        this.signature = (byte)signature;
    }

    public byte signature() {
        return this.signature;
    }

    static {
        valuesBySignature = new BoltResponseMessage[128];
        BoltResponseMessage[] boltResponseMessageArray = BoltResponseMessage.values();
        int n = boltResponseMessageArray.length;
        for (int i = 0; i < n; ++i) {
            BoltResponseMessage value;
            BoltResponseMessage.valuesBySignature[value.signature()] = value = boltResponseMessageArray[i];
        }
    }
}

