/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.security.auth;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.security.auth.BasicAuthenticationResult;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;

public class BasicAuthentication
implements Authentication {
    private final AuthManager authManager;
    private final UserManagerSupplier userManagerSupplier;

    public BasicAuthentication(AuthManager authManager, UserManagerSupplier userManagerSupplier) {
        this.authManager = authManager;
        this.userManagerSupplier = userManagerSupplier;
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        if (authToken.containsKey("new_credentials")) {
            return this.update(authToken);
        }
        return this.doAuthenticate(authToken);
    }

    private AuthenticationResult doAuthenticate(Map<String, Object> authToken) throws AuthenticationException {
        try {
            LoginContext loginContext = this.authManager.login(authToken);
            switch (loginContext.subject().getAuthenticationResult()) {
                case SUCCESS: 
                case PASSWORD_CHANGE_REQUIRED: {
                    break;
                }
                case TOO_MANY_ATTEMPTS: {
                    throw new AuthenticationException((Status)Status.Security.AuthenticationRateLimit);
                }
                default: {
                    throw new AuthenticationException((Status)Status.Security.Unauthorized);
                }
            }
            return new BasicAuthenticationResult(loginContext);
        }
        catch (InvalidAuthTokenException e) {
            throw new AuthenticationException(e.status(), e.getMessage());
        }
    }

    private AuthenticationResult update(Map<String, Object> authToken) throws AuthenticationException {
        try {
            LoginContext loginContext = this.authManager.login(authToken);
            switch (loginContext.subject().getAuthenticationResult()) {
                case SUCCESS: 
                case PASSWORD_CHANGE_REQUIRED: {
                    String newPassword = AuthToken.safeCast((String)"new_credentials", authToken);
                    String username = AuthToken.safeCast((String)"principal", authToken);
                    this.userManagerSupplier.getUserManager(loginContext.subject(), false).setUserPassword(username, newPassword, false);
                    loginContext.subject().setPasswordChangeNoLongerRequired();
                    break;
                }
                default: {
                    throw new AuthenticationException((Status)Status.Security.Unauthorized);
                }
            }
            return new BasicAuthenticationResult(loginContext);
        }
        catch (AuthorizationViolationException | InvalidArgumentsException | InvalidAuthTokenException e) {
            throw new AuthenticationException(((Status.HasStatus)e).status(), e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AuthenticationException((Status)Status.Security.Unauthorized, e.getMessage(), e);
        }
    }
}

