/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstaller;
import org.neo4j.bolt.transport.BoltProtocolPipelineInstallerFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ProtocolHandshaker
extends ChannelInboundHandlerAdapter {
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;
    private static final int HANDSHAKE_BUFFER_SIZE = 20;
    private final BoltChannel boltChannel;
    private final BoltProtocolPipelineInstallerFactory handlerFactory;
    private final Log log;
    private final boolean encryptionRequired;
    private final boolean encrypted;
    private ByteBuf handshakeBuffer;
    private BoltProtocolPipelineInstaller protocol;

    public ProtocolHandshaker(BoltProtocolPipelineInstallerFactory handlerFactory, BoltChannel boltChannel, LogProvider logging, boolean encryptionRequired, boolean encrypted) {
        this.handlerFactory = handlerFactory;
        this.boltChannel = boltChannel;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
        this.encryptionRequired = encryptionRequired;
        this.encrypted = encrypted;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeBuffer = ctx.alloc().buffer(20, 20);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.handshakeBuffer.release();
        this.handshakeBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (!(msg instanceof ByteBuf)) {
            this.log.warn("Unsupported connection type: 'HTTP'. Bolt protocol only operates over a TCP connection or WebSocket.");
            ctx.close();
            return;
        }
        ByteBuf buf = (ByteBuf)msg;
        try {
            this.assertEncryptedIfRequired();
            this.handshakeBuffer.writeBytes(buf, Math.min(buf.readableBytes(), this.handshakeBuffer.writableBytes()));
            if (this.handshakeBuffer.writableBytes() == 0) {
                if (this.verifyBoltPreamble()) {
                    if (this.performHandshake()) {
                        ctx.writeAndFlush((Object)ctx.alloc().buffer(4).writeInt((int)this.protocol.version()));
                        this.protocol.install();
                        ctx.pipeline().remove((ChannelHandler)this);
                        if (buf.readableBytes() > 0) {
                            ctx.fireChannelRead((Object)buf.readRetainedSlice(buf.readableBytes()));
                        }
                    } else {
                        ctx.writeAndFlush((Object)ctx.alloc().buffer().writeBytes(new byte[]{0, 0, 0, 0})).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                } else {
                    ctx.close();
                }
            }
        }
        finally {
            buf.release();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof SecurityException) {
            this.boltChannel.log().serverError("HANDSHAKE", "Insecure handshake");
        }
        this.log.error("Fatal error occurred during protocol handshaking: " + ctx.channel(), cause);
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.close();
    }

    private void assertEncryptedIfRequired() {
        if (this.encryptionRequired && !this.encrypted) {
            throw new SecurityException("An unencrypted connection attempt was made where encryption is required.");
        }
    }

    private boolean verifyBoltPreamble() {
        if (this.handshakeBuffer.getInt(0) != 1616949271) {
            this.boltChannel.log().clientError("HANDSHAKE", "Invalid Bolt signature", () -> String.format("0x%08X", this.handshakeBuffer.getInt(0)));
            return false;
        }
        return true;
    }

    private boolean performHandshake() {
        this.boltChannel.log().clientEvent("HANDSHAKE", () -> String.format("0x%08X", 1616949271));
        for (int i = 0; i < 4; ++i) {
            long suggestion = (long)this.handshakeBuffer.getInt((i + 1) * 4) & 0xFFFFFFFFL;
            this.protocol = this.handlerFactory.create(suggestion, this.boltChannel);
            if (this.protocol == null) continue;
            this.boltChannel.log().serverEvent("HANDSHAKE", () -> String.format("0x%02X", suggestion));
            break;
        }
        if (this.protocol == null) {
            this.boltChannel.log().serverError("HANDSHAKE", "No applicable protocol");
        }
        return this.protocol != null;
    }
}

