/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

public enum BoltRequestMessage {
    INIT(1),
    ACK_FAILURE(14),
    RESET(15),
    RUN(16),
    DISCARD_ALL(47),
    PULL_ALL(63);

    private static final BoltRequestMessage[] valuesBySignature;
    private final byte signature;

    public static BoltRequestMessage withSignature(int signature) {
        if (signature < 0 || signature > valuesBySignature.length - 1) {
            return null;
        }
        return valuesBySignature[signature];
    }

    private BoltRequestMessage(int signature) {
        this.signature = (byte)signature;
    }

    public byte signature() {
        return this.signature;
    }

    static {
        valuesBySignature = new BoltRequestMessage[64];
        BoltRequestMessage[] boltRequestMessageArray = BoltRequestMessage.values();
        int n = boltRequestMessageArray.length;
        for (int i = 0; i < n; ++i) {
            BoltRequestMessage value;
            BoltRequestMessage.valuesBySignature[value.signature()] = value = boltRequestMessageArray[i];
        }
    }
}

