/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.bolt.v1.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class MessageProcessingHandler
implements BoltResponseHandler {
    private static final Set<Status> CLIENT_MID_OP_DISCONNECT_ERRORS = new HashSet<Status.Transaction>(Arrays.asList(Status.Transaction.Terminated, Status.Transaction.LockClientStopped));
    protected final Map<String, AnyValue> metadata = new HashMap<String, AnyValue>();
    protected final Log log;
    protected final BoltConnection connection;
    protected final BoltResponseMessageHandler<IOException> handler;
    private Neo4jError error;
    private boolean ignored;

    MessageProcessingHandler(BoltResponseMessageHandler<IOException> handler, BoltConnection connection, Log logger) {
        this.handler = handler;
        this.connection = connection;
        this.log = logger;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onRecords(BoltResult result, boolean pull) throws Exception {
    }

    @Override
    public void onMetadata(String key, AnyValue value) {
        this.metadata.put(key, value);
    }

    @Override
    public void markIgnored() {
        this.ignored = true;
    }

    @Override
    public void markFailed(Neo4jError error) {
        this.error = error;
    }

    @Override
    public void onFinish() {
        try {
            if (this.ignored) {
                this.handler.onIgnored();
            } else if (this.error != null) {
                this.publishError(this.handler, this.error);
            } else {
                this.handler.onSuccess(this.getMetadata());
            }
        }
        catch (Throwable e) {
            this.connection.stop();
            this.log.error("Failed to write response to driver", e);
        }
        finally {
            this.clearState();
        }
    }

    MapValue getMetadata() {
        return VirtualValues.map(this.metadata);
    }

    private void clearState() {
        this.error = null;
        this.ignored = false;
        this.metadata.clear();
    }

    private void publishError(BoltResponseMessageHandler<IOException> out, Neo4jError error) {
        try {
            if (error.isFatal()) {
                out.onFatal(error.status(), error.message());
            } else {
                out.onFailure(error.status(), error.message());
            }
        }
        catch (PackOutputClosedException e) {
            if (CLIENT_MID_OP_DISCONNECT_ERRORS.contains(error.status())) {
                this.log.warn("Client %s disconnected while query was running. Session has been cleaned up. This can be caused by temporary network problems, but if you see this often, ensure your applications are properly waiting for operations to complete before exiting.", new Object[]{e.clientAddress()});
                return;
            }
            this.log.warn("Unable to send error back to the client. " + e.getMessage(), error.cause());
        }
        catch (Throwable t) {
            t.addSuppressed(error.cause());
            this.log.error("Unable to send error back to the client", t);
        }
    }
}

