/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.request;

import java.util.Objects;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class RunMessage
implements RequestMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final MapValue params;

    public RunMessage(String statement) {
        this(statement, VirtualValues.EMPTY_MAP);
    }

    public RunMessage(String statement, MapValue params) {
        this.statement = Objects.requireNonNull(statement);
        this.params = Objects.requireNonNull(params);
    }

    public String statement() {
        return this.statement;
    }

    public MapValue params() {
        return this.params;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.statement, this.params);
    }

    public String toString() {
        return "RUN " + this.statement + ' ' + this.params;
    }
}

