/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Map;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.runtime.BoltAuthenticationHelper;
import org.neo4j.util.Preconditions;

public class ConnectedState
implements BoltStateMachineState {
    private BoltStateMachineState readyState;
    private BoltStateMachineState failedState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof InitMessage) {
            Map<String, Object> authToken;
            InitMessage initMessage = (InitMessage)message;
            String userAgent = initMessage.userAgent();
            if (BoltAuthenticationHelper.processAuthentication(userAgent, authToken = initMessage.authToken(), context)) {
                return this.readyState;
            }
            return this.failedState;
        }
        return null;
    }

    @Override
    public String name() {
        return "CONNECTED";
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    public void setFailedState(BoltStateMachineState failedState) {
        this.failedState = failedState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        Preconditions.checkState((this.failedState != null ? 1 : 0) != 0, (String)"Failed state not set");
    }
}

