/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.util.Preconditions;

public class InterruptedState
implements BoltStateMachineState {
    private BoltStateMachineState readyState;

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof InterruptSignal) {
            return this;
        }
        if (message instanceof ResetMessage) {
            if (context.connectionState().decrementInterruptCounter() > 0) {
                context.connectionState().markIgnored();
                return this;
            }
            boolean success = context.resetMachine();
            return success ? this.readyState : null;
        }
        context.connectionState().markIgnored();
        return this;
    }

    @Override
    public String name() {
        return "INTERRUPTED";
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
    }
}

