/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.v1.BoltProtocolV1;
import org.neo4j.bolt.v2.BoltProtocolV2;
import org.neo4j.bolt.v3.BoltProtocolV3;
import org.neo4j.logging.internal.LogService;

public class DefaultBoltProtocolFactory
implements BoltProtocolFactory {
    private final BoltConnectionFactory connectionFactory;
    private final LogService logService;
    private final BoltStateMachineFactory stateMachineFactory;

    public DefaultBoltProtocolFactory(BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, LogService logService) {
        this.connectionFactory = connectionFactory;
        this.stateMachineFactory = stateMachineFactory;
        this.logService = logService;
    }

    @Override
    public BoltProtocol create(long protocolVersion, BoltChannel channel) {
        if (protocolVersion == 1L) {
            return new BoltProtocolV1(channel, this.connectionFactory, this.stateMachineFactory, this.logService);
        }
        if (protocolVersion == 2L) {
            return new BoltProtocolV2(channel, this.connectionFactory, this.stateMachineFactory, this.logService);
        }
        if (protocolVersion == 3L) {
            return new BoltProtocolV3(channel, this.connectionFactory, this.stateMachineFactory, this.logService);
        }
        return null;
    }
}

