/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.StructType;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.packstream.PackType;
import org.neo4j.collection.primitive.PrimitiveLongIntKeyValueArray;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ReadAndDeleteTransactionConflictException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public class Neo4jPackV1
implements Neo4jPack {
    public static final long VERSION = 1L;
    public static final byte NODE = 78;
    public static final int NODE_SIZE = 3;
    public static final byte RELATIONSHIP = 82;
    public static final int RELATIONSHIP_SIZE = 5;
    public static final byte UNBOUND_RELATIONSHIP = 114;
    public static final int UNBOUND_RELATIONSHIP_SIZE = 3;
    public static final byte PATH = 80;
    public static final int PATH_SIZE = 3;

    @Override
    public Neo4jPack.Packer newPacker(PackOutput output) {
        return new PackerV1(output);
    }

    @Override
    public Neo4jPack.Unpacker newUnpacker(PackInput input) {
        return new UnpackerV1(input);
    }

    @Override
    public long version() {
        return 1L;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected static class UnpackerV1
    extends PackStream.Unpacker
    implements Neo4jPack.Unpacker {
        protected UnpackerV1(PackInput input) {
            super(input);
        }

        @Override
        public AnyValue unpack() throws IOException {
            PackType valType = this.peekNextType();
            switch (valType) {
                case BYTES: {
                    return Values.byteArray((byte[])this.unpackBytes());
                }
                case STRING: {
                    return Values.utf8Value((byte[])this.unpackUTF8());
                }
                case INTEGER: {
                    return Values.longValue((long)this.unpackLong());
                }
                case FLOAT: {
                    return Values.doubleValue((double)this.unpackDouble());
                }
                case BOOLEAN: {
                    return Values.booleanValue((boolean)this.unpackBoolean());
                }
                case NULL: {
                    this.unpackNull();
                    return Values.NO_VALUE;
                }
                case LIST: {
                    return this.unpackList();
                }
                case MAP: {
                    return this.unpackMap();
                }
                case STRUCT: {
                    long size = this.unpackStructHeader();
                    char signature = this.unpackStructSignature();
                    return this.unpackStruct(signature, size);
                }
                case END_OF_STREAM: {
                    this.unpackEndOfStream();
                    return null;
                }
            }
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unknown value type: " + (Object)((Object)valType));
        }

        ListValue unpackList() throws IOException {
            int size = (int)this.unpackListHeader();
            if (size == 0) {
                return VirtualValues.EMPTY_LIST;
            }
            if ((long)size == -1L) {
                ArrayList<AnyValue> list = new ArrayList<AnyValue>();
                boolean more = true;
                block3: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block3;
                        }
                    }
                    list.add(this.unpack());
                }
                return VirtualValues.list((AnyValue[])list.toArray(new AnyValue[0]));
            }
            AnyValue[] values = new AnyValue[size];
            for (int i = 0; i < size; ++i) {
                values[i] = this.unpack();
            }
            return VirtualValues.list((AnyValue[])values);
        }

        protected AnyValue unpackStruct(char signature, long size) throws IOException {
            StructType structType = StructType.valueOf(signature);
            if (structType == null) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Struct types of 0x%s are not recognized.", Integer.toHexString(signature)));
            }
            throw new BoltIOException((Status)Status.Statement.TypeError, String.format("%s values cannot be unpacked with this version of bolt.", structType.description()));
        }

        @Override
        public MapValue unpackMap() throws IOException {
            MapValueBuilder map;
            int size = (int)this.unpackMapHeader();
            if (size == 0) {
                return VirtualValues.EMPTY_MAP;
            }
            if ((long)size == -1L) {
                map = new MapValueBuilder();
                boolean more = true;
                block9: while (more) {
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case END_OF_STREAM: {
                            this.unpack();
                            more = false;
                            continue block9;
                        }
                        case STRING: {
                            AnyValue val;
                            String key = this.unpackString();
                            if (map.add(key, val = this.unpack()) == null) continue block9;
                            throw new BoltIOException((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`.");
                        }
                        case NULL: {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string.");
                        }
                    }
                    throw new BoltIOException((Status)Status.Request.InvalidFormat, "Bad key type: " + (Object)((Object)keyType));
                }
            } else {
                map = new MapValueBuilder(size);
                for (int i = 0; i < size; ++i) {
                    String key;
                    PackType keyType = this.peekNextType();
                    switch (keyType) {
                        case NULL: {
                            throw new BoltIOException((Status)Status.Request.Invalid, "Value `null` is not supported as key in maps, must be a non-nullable string.");
                        }
                        case STRING: {
                            key = this.unpackString();
                            break;
                        }
                        default: {
                            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Bad key type: " + (Object)((Object)keyType));
                        }
                    }
                    AnyValue val = this.unpack();
                    if (map.add(key, val) == null) continue;
                    throw new BoltIOException((Status)Status.Request.Invalid, "Duplicate map key `" + key + "`.");
                }
            }
            return map.build();
        }
    }

    protected static class PackerV1
    extends PackStream.Packer
    implements AnyValueWriter<IOException>,
    Neo4jPack.Packer {
        private static final int INITIAL_PATH_CAPACITY = 500;
        private static final int NO_SUCH_ID = -1;
        private final PrimitiveLongIntKeyValueArray nodeIndexes = new PrimitiveLongIntKeyValueArray(501);
        private final PrimitiveLongIntKeyValueArray relationshipIndexes = new PrimitiveLongIntKeyValueArray(500);

        protected PackerV1(PackOutput output) {
            super(output);
        }

        @Override
        public void pack(AnyValue value) throws IOException {
            value.writeTo((AnyValueWriter)this);
        }

        public void writeNodeReference(long nodeId) {
            throw new UnsupportedOperationException("Cannot write a raw node reference");
        }

        public void writeNode(long nodeId, TextArray labels, MapValue properties) throws IOException {
            this.packStructHeader(3, (byte)78);
            this.pack(nodeId);
            this.packListHeader(labels.length());
            for (int i = 0; i < labels.length(); ++i) {
                labels.value(i).writeTo((AnyValueWriter)this);
            }
            properties.writeTo((AnyValueWriter)this);
        }

        public void writeRelationshipReference(long relationshipId) {
            throw new UnsupportedOperationException("Cannot write a raw relationship reference");
        }

        public void writeRelationship(long relationshipId, long startNodeId, long endNodeId, TextValue type, MapValue properties) throws IOException {
            this.packStructHeader(5, (byte)82);
            this.pack(relationshipId);
            this.pack(startNodeId);
            this.pack(endNodeId);
            type.writeTo((AnyValueWriter)this);
            properties.writeTo((AnyValueWriter)this);
        }

        public void beginMap(int size) throws IOException {
            this.packMapHeader(size);
        }

        public void endMap() {
        }

        public void beginList(int size) throws IOException {
            this.packListHeader(size);
        }

        public void endList() {
        }

        public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) throws IOException {
            this.packStructHeader(3, (byte)80);
            this.writeNodesForPath(nodes);
            this.writeRelationshipsForPath(relationships);
            this.packListHeader(2 * relationships.length);
            if (relationships.length == 0) {
                return;
            }
            NodeValue node = nodes[0];
            for (int i = 1; i <= 2 * relationships.length; ++i) {
                if (i % 2 == 0) {
                    node = nodes[i / 2];
                    int index = this.nodeIndexes.getOrDefault(node.id(), -1);
                    this.pack(index);
                    continue;
                }
                RelationshipValue r = relationships[i / 2];
                int index = this.relationshipIndexes.getOrDefault(r.id(), -1);
                if (node.id() == r.startNode().id()) {
                    this.pack(index);
                    continue;
                }
                this.pack(-index);
            }
        }

        private void writeNodesForPath(NodeValue[] nodes) throws IOException {
            this.nodeIndexes.reset(nodes.length);
            for (NodeValue node : nodes) {
                this.nodeIndexes.putIfAbsent(node.id(), this.nodeIndexes.size());
            }
            int size = this.nodeIndexes.size();
            this.packListHeader(size);
            if (size > 0) {
                NodeValue node = nodes[0];
                for (long id : this.nodeIndexes.keys()) {
                    int i = 1;
                    while (node.id() != id) {
                        node = nodes[i++];
                    }
                    node.writeTo((AnyValueWriter)this);
                }
            }
        }

        private void writeRelationshipsForPath(RelationshipValue[] relationships) throws IOException {
            this.relationshipIndexes.reset(relationships.length);
            for (RelationshipValue node : relationships) {
                this.relationshipIndexes.putIfAbsent(node.id(), this.relationshipIndexes.size() + 1);
            }
            int size = this.relationshipIndexes.size();
            this.packListHeader(size);
            if (size > 0) {
                RelationshipValue edge = relationships[0];
                for (long id : this.relationshipIndexes.keys()) {
                    int i = 1;
                    while (edge.id() != id) {
                        edge = relationships[i++];
                    }
                    this.packStructHeader(3, (byte)114);
                    this.pack(edge.id());
                    edge.type().writeTo((AnyValueWriter)this);
                    try {
                        edge.properties().writeTo((AnyValueWriter)this);
                    }
                    catch (ReadAndDeleteTransactionConflictException e) {
                        if (!e.wasDeletedInThisTransaction()) {
                            throw e;
                        }
                        VirtualValues.EMPTY_MAP.writeTo((AnyValueWriter)this);
                    }
                }
            }
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
            this.throwUnsupportedTypeError("Point");
        }

        public void writeDuration(long months, long days, long seconds, int nanos) throws IOException {
            this.throwUnsupportedTypeError("Duration");
        }

        public void writeDate(LocalDate localDate) throws IOException {
            this.throwUnsupportedTypeError("Date");
        }

        public void writeLocalTime(LocalTime localTime) throws IOException {
            this.throwUnsupportedTypeError("LocalTime");
        }

        public void writeTime(OffsetTime offsetTime) throws IOException {
            this.throwUnsupportedTypeError("Time");
        }

        public void writeLocalDateTime(LocalDateTime localDateTime) throws IOException {
            this.throwUnsupportedTypeError("LocalDateTime");
        }

        public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
            this.throwUnsupportedTypeError("DateTime");
        }

        public void writeNull() throws IOException {
            this.packNull();
        }

        public void writeBoolean(boolean value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(byte value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(short value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(int value) throws IOException {
            this.pack(value);
        }

        public void writeInteger(long value) throws IOException {
            this.pack(value);
        }

        public void writeFloatingPoint(float value) throws IOException {
            this.pack(value);
        }

        public void writeFloatingPoint(double value) throws IOException {
            this.pack(value);
        }

        public void writeUTF8(byte[] bytes, int offset, int length) throws IOException {
            this.packUTF8(bytes, offset, length);
        }

        public void writeString(String value) throws IOException {
            this.pack(value);
        }

        public void writeString(char value) throws IOException {
            this.pack(value);
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IOException {
            switch (arrayType) {
                case BYTE: {
                    this.packBytesHeader(size);
                    break;
                }
                default: {
                    this.packListHeader(size);
                }
            }
        }

        public void endArray() {
        }

        public void writeByteArray(byte[] value) throws IOException {
            this.pack(value);
        }

        void throwUnsupportedTypeError(String type) throws BoltIOException {
            throw new BoltIOException((Status)Status.Request.Invalid, type + " is not supported as a return type in Bolt protocol version 1. Please make sure driver supports at least protocol version 2. Driver upgrade is most likely required.");
        }
    }
}

