/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.bookmarking;

import java.util.Objects;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.runtime.bookmarking.BookmarkFormatException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public class Bookmark {
    private static final String BOOKMARK_KEY = "bookmark";
    private static final String BOOKMARKS_KEY = "bookmarks";
    static final String BOOKMARK_TX_PREFIX = "neo4j:bookmark:v1:tx";
    private final long txId;

    public Bookmark(long txId) {
        this.txId = txId;
    }

    public static Bookmark fromParamsOrNull(MapValue params) throws BookmarkFormatException {
        Bookmark bookmark = Bookmark.parseMultipleBookmarks(params);
        if (bookmark == null) {
            return Bookmark.parseSingleBookmark(params);
        }
        return bookmark;
    }

    public long txId() {
        return this.txId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bookmark bookmark = (Bookmark)o;
        return this.txId == bookmark.txId;
    }

    public int hashCode() {
        return Objects.hash(this.txId);
    }

    public String toString() {
        return String.format("neo4j:bookmark:v1:tx%d", this.txId);
    }

    private static Bookmark parseMultipleBookmarks(MapValue params) throws BookmarkFormatException {
        AnyValue bookmarksObject = params.get(BOOKMARKS_KEY);
        if (bookmarksObject == Values.NO_VALUE) {
            return null;
        }
        if (bookmarksObject instanceof ListValue) {
            ListValue bookmarks = (ListValue)bookmarksObject;
            long maxTxId = -1L;
            for (AnyValue bookmark : bookmarks) {
                long txId;
                if (bookmark == Values.NO_VALUE || (txId = Bookmark.txIdFrom(bookmark)) <= maxTxId) continue;
                maxTxId = txId;
            }
            return maxTxId == -1L ? null : new Bookmark(maxTxId);
        }
        throw new BookmarkFormatException(bookmarksObject);
    }

    private static Bookmark parseSingleBookmark(MapValue params) throws BookmarkFormatException {
        AnyValue bookmarkObject = params.get(BOOKMARK_KEY);
        if (bookmarkObject == Values.NO_VALUE) {
            return null;
        }
        return new Bookmark(Bookmark.txIdFrom(bookmarkObject));
    }

    private static long txIdFrom(AnyValue bookmark) throws BookmarkFormatException {
        if (!(bookmark instanceof TextValue)) {
            throw new BookmarkFormatException(bookmark);
        }
        String bookmarkString = ((TextValue)bookmark).stringValue();
        if (!bookmarkString.startsWith(BOOKMARK_TX_PREFIX)) {
            throw new BookmarkFormatException((Object)bookmarkString);
        }
        try {
            return Long.parseLong(bookmarkString.substring(BOOKMARK_TX_PREFIX.length()));
        }
        catch (NumberFormatException e) {
            throw new BookmarkFormatException(bookmarkString, e);
        }
    }

    public void attachTo(BoltResponseHandler state) {
        state.onMetadata(BOOKMARK_KEY, (AnyValue)Values.stringValue((String)this.toString()));
    }
}

