/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Clock;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.DefaultBoltConnectionFactory;
import org.neo4j.bolt.runtime.scheduling.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.scheduling.CachedThreadPoolExecutorFactory;
import org.neo4j.bolt.runtime.scheduling.ExecutorBoltSchedulerProvider;
import org.neo4j.bolt.runtime.scheduling.NettyThreadFactory;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.runtime.statemachine.impl.BoltStateMachineFactoryImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.DefaultBoltProtocolFactory;
import org.neo4j.bolt.transport.Netty4LoggerFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.time.SystemNanoClock;

public class BoltServer
extends LifecycleAdapter {
    private final BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI;
    private final JobScheduler jobScheduler;
    private final ConnectorPortRegister connectorPortRegister;
    private final NetworkConnectionTracker connectionTracker;
    private final DatabaseIdRepository databaseIdRepository;
    private final Config config;
    private final SystemNanoClock clock;
    private final Monitors monitors;
    private final LogService logService;
    private final AuthManager authManager;
    private final DependencyResolver dependencyResolver;
    private final LifeSupport life = new LifeSupport();

    public BoltServer(BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, JobScheduler jobScheduler, ConnectorPortRegister connectorPortRegister, NetworkConnectionTracker connectionTracker, DatabaseIdRepository databaseIdRepository, Config config, SystemNanoClock clock, Monitors monitors, LogService logService, DependencyResolver dependencyResolver, AuthManager authManager) {
        this.boltGraphDatabaseManagementServiceSPI = boltGraphDatabaseManagementServiceSPI;
        this.jobScheduler = jobScheduler;
        this.connectorPortRegister = connectorPortRegister;
        this.connectionTracker = connectionTracker;
        this.databaseIdRepository = databaseIdRepository;
        this.config = config;
        this.clock = clock;
        this.monitors = monitors;
        this.logService = logService;
        this.dependencyResolver = dependencyResolver;
        this.authManager = authManager;
    }

    public void init() {
        Log log = this.logService.getInternalLog(BoltServer.class);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(this.logService.getInternalLogProvider()));
        Authentication authentication = this.createAuthentication();
        TransportThrottleGroup throttleGroup = new TransportThrottleGroup(this.config, (Clock)this.clock);
        BoltSchedulerProvider boltSchedulerProvider = (BoltSchedulerProvider)this.life.setLast((Lifecycle)new ExecutorBoltSchedulerProvider(this.config, new CachedThreadPoolExecutorFactory(), this.jobScheduler, this.logService));
        BoltConnectionFactory boltConnectionFactory = this.createConnectionFactory(this.config, boltSchedulerProvider, throttleGroup, this.logService, (Clock)this.clock);
        BoltStateMachineFactory boltStateMachineFactory = this.createBoltStateMachineFactory(authentication, this.clock);
        BoltProtocolFactory boltProtocolFactory = this.createBoltProtocolFactory(boltConnectionFactory, boltStateMachineFactory);
        if (((Boolean)this.config.get(BoltConnector.enabled)).booleanValue()) {
            this.jobScheduler.setThreadFactory(Group.BOLT_NETWORK_IO, NettyThreadFactory::new);
            NettyServer server = new NettyServer(this.jobScheduler.threadFactory(Group.BOLT_NETWORK_IO), this.createProtocolInitializer(boltProtocolFactory, throttleGroup, log), this.connectorPortRegister, this.logService);
            this.life.add((Lifecycle)server);
            log.info("Bolt server loaded");
        }
        this.life.init();
    }

    public void start() throws Exception {
        this.life.start();
    }

    public void stop() throws Exception {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }

    private BoltConnectionFactory createConnectionFactory(Config config, BoltSchedulerProvider schedulerProvider, TransportThrottleGroup throttleGroup, LogService logService, Clock clock) {
        return new DefaultBoltConnectionFactory(schedulerProvider, throttleGroup, config, logService, clock, this.monitors);
    }

    private NettyServer.ProtocolInitializer createProtocolInitializer(BoltProtocolFactory boltProtocolFactory, TransportThrottleGroup throttleGroup, Log log) {
        SslContext sslCtx;
        boolean requireEncryption;
        BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)this.config.get(BoltConnector.encryption_level);
        SslPolicyLoader sslPolicyLoader = (SslPolicyLoader)this.dependencyResolver.resolveDependency(SslPolicyLoader.class);
        switch (encryptionLevel) {
            case REQUIRED: {
                requireEncryption = true;
                sslCtx = BoltServer.createSslContext(sslPolicyLoader);
                break;
            }
            case OPTIONAL: {
                requireEncryption = false;
                sslCtx = BoltServer.createSslContext(sslPolicyLoader);
                break;
            }
            case DISABLED: {
                requireEncryption = false;
                sslCtx = null;
                break;
            }
            default: {
                log.warn("Unhandled encryption level %s - assuming DISABLED.", new Object[]{encryptionLevel.name()});
                requireEncryption = false;
                sslCtx = null;
            }
        }
        SocketAddress listenAddress = (SocketAddress)this.config.get(BoltConnector.listen_address);
        return new SocketTransport("bolt", listenAddress, sslCtx, requireEncryption, this.logService.getInternalLogProvider(), throttleGroup, boltProtocolFactory, this.connectionTracker);
    }

    private static SslContext createSslContext(SslPolicyLoader sslPolicyFactory) {
        try {
            if (!sslPolicyFactory.hasPolicyForSource(SslPolicyScope.BOLT)) {
                throw new IllegalArgumentException("No SSL policy has been configured for Bolt server");
            }
            return sslPolicyFactory.getPolicy(SslPolicyScope.BOLT).nettyServerContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SSL encryption support, which is required to start this connector. Error was: " + e.getMessage(), e);
        }
    }

    private Authentication createAuthentication() {
        return new BasicAuthentication(this.authManager);
    }

    private BoltProtocolFactory createBoltProtocolFactory(BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory) {
        CustomBookmarkFormatParser customBookmarkParser = this.boltGraphDatabaseManagementServiceSPI.getCustomBookmarkFormatParser().orElse(CustomBookmarkFormatParser.DEFAULT);
        return new DefaultBoltProtocolFactory(connectionFactory, stateMachineFactory, this.logService, this.databaseIdRepository, customBookmarkParser);
    }

    private BoltStateMachineFactory createBoltStateMachineFactory(Authentication authentication, SystemNanoClock clock) {
        return new BoltStateMachineFactoryImpl(this.boltGraphDatabaseManagementServiceSPI, authentication, clock, this.config, this.logService);
    }
}

