/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.dbapi.BookmarkMetadata;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.BoltAdapterSubscriber;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarkWithPrefix;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public abstract class AbstractTransactionStateMachineSPI
implements TransactionStateMachineSPI {
    private final BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI;
    private final Clock clock;
    private final BoltChannel boltChannel;
    private final StatementProcessorReleaseManager resourceReleaseManager;

    public AbstractTransactionStateMachineSPI(BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI, BoltChannel boltChannel, SystemNanoClock clock, StatementProcessorReleaseManager resourceReleaseManger) {
        this.boltGraphDatabaseServiceSPI = boltGraphDatabaseServiceSPI;
        this.boltChannel = boltChannel;
        this.clock = clock;
        this.resourceReleaseManager = resourceReleaseManger;
    }

    @Override
    public Bookmark newestBookmark(BoltTransaction tx) {
        BookmarkMetadata bookmarkMetadata = tx.getBookmarkMetadata();
        return bookmarkMetadata.toBookmark((txId, dbId) -> new BookmarkWithPrefix((long)txId));
    }

    @Override
    public BoltTransaction beginTransaction(LoginContext loginContext, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) {
        return this.boltGraphDatabaseServiceSPI.beginTransaction(KernelTransaction.Type.explicit, loginContext, this.boltChannel.info(), bookmarks, txTimeout, accessMode, txMetadata);
    }

    @Override
    public BoltTransaction beginPeriodicCommitTransaction(LoginContext loginContext, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) {
        return this.boltGraphDatabaseServiceSPI.beginTransaction(KernelTransaction.Type.implicit, loginContext, this.boltChannel.info(), bookmarks, txTimeout, accessMode, txMetadata);
    }

    @Override
    public boolean isPeriodicCommit(String query) {
        return this.boltGraphDatabaseServiceSPI.isPeriodicCommit(query);
    }

    @Override
    public BoltResultHandle executeQuery(BoltQueryExecutor boltQueryExecutor, String statement, MapValue params) {
        return this.newBoltResultHandle(statement, params, boltQueryExecutor);
    }

    @Override
    public boolean supportsNestedStatementsInTransaction() {
        return false;
    }

    @Override
    public void transactionClosed() {
        this.resourceReleaseManager.releaseStatementProcessor();
    }

    protected abstract BoltResultHandle newBoltResultHandle(String var1, MapValue var2, BoltQueryExecutor var3);

    public abstract class AbstractBoltResultHandle
    implements BoltResultHandle {
        private final String statement;
        private final MapValue params;
        private final BoltQueryExecutor boltQueryExecutor;
        private BoltQueryExecution boltQueryExecution;

        public AbstractBoltResultHandle(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
            this.statement = statement;
            this.params = params;
            this.boltQueryExecutor = boltQueryExecutor;
        }

        @Override
        public BoltResult start() throws KernelException {
            try {
                BoltAdapterSubscriber subscriber = new BoltAdapterSubscriber();
                this.boltQueryExecution = this.boltQueryExecutor.executeQuery(this.statement, this.params, true, subscriber);
                QueryExecution result = this.boltQueryExecution.getQueryExecution();
                subscriber.assertSucceeded();
                return this.newBoltResult(result, subscriber, AbstractTransactionStateMachineSPI.this.clock);
            }
            catch (KernelException e) {
                throw new QueryExecutionKernelException((Throwable)e);
            }
            finally {
                this.close(false);
            }
        }

        protected abstract BoltResult newBoltResult(QueryExecution var1, BoltAdapterSubscriber var2, Clock var3);

        @Override
        public void close(boolean success) {
            if (this.boltQueryExecution != null) {
                this.boltQueryExecution.close();
            }
        }

        @Override
        public void terminate() {
            if (this.boltQueryExecution != null) {
                this.boltQueryExecution.terminate();
            }
        }
    }
}

