/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import java.util.Objects;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.MutableConnectionState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.StatementProcessorProvider;
import org.neo4j.bolt.security.auth.AuthenticationResult;

public class BoltStateMachineContextImpl
implements StateMachineContext,
StatementProcessorReleaseManager {
    private final BoltStateMachine machine;
    private final BoltChannel boltChannel;
    private final BoltStateMachineSPI spi;
    private final MutableConnectionState connectionState;
    private final Clock clock;
    private final boolean renameThreads;
    private final String defaultDatabaseName;
    private StatementProcessorProvider statementProcessorProvider;

    public BoltStateMachineContextImpl(BoltStateMachine machine, BoltChannel boltChannel, BoltStateMachineSPI spi, MutableConnectionState connectionState, Clock clock, boolean renameThreads, String defaultDatabaseName) {
        this.machine = machine;
        this.boltChannel = boltChannel;
        this.spi = spi;
        this.connectionState = connectionState;
        this.clock = clock;
        this.renameThreads = renameThreads;
        this.defaultDatabaseName = defaultDatabaseName;
    }

    @Override
    public void authenticatedAsUser(String username, String userAgent) {
        this.boltChannel.updateUser(username, userAgent);
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        this.machine.handleFailure(cause, fatal);
    }

    @Override
    public boolean resetMachine() throws BoltConnectionFatality {
        return this.machine.reset();
    }

    @Override
    public BoltStateMachineSPI boltSpi() {
        return this.spi;
    }

    @Override
    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public String connectionId() {
        return this.machine.id();
    }

    @Override
    public void initStatementProcessorProvider(AuthenticationResult authResult) {
        TransactionStateMachineSPIProvider transactionSpiProvider = this.spi.transactionStateMachineSPIProvider();
        this.setStatementProcessorProvider(new StatementProcessorProvider(authResult, transactionSpiProvider, this.clock, this));
    }

    @Override
    public StatementProcessor setCurrentStatementProcessorForDatabase(String databaseName) throws BoltProtocolBreachFatality, BoltIOException {
        if (this.isCurrentStatementProcessorNotSet(databaseName)) {
            StatementProcessor statementProcessor = this.statementProcessorProvider.getStatementProcessor(databaseName);
            this.connectionState().setStatementProcessor(statementProcessor);
            this.extendThreadName(databaseName);
            return statementProcessor;
        }
        return this.connectionState().getStatementProcessor();
    }

    @Override
    public void releaseStatementProcessor() {
        this.extendThreadName(null);
        this.connectionState().clearStatementProcessor();
    }

    private boolean isCurrentStatementProcessorNotSet(String databaseName) throws BoltProtocolBreachFatality {
        StatementProcessor currentProcessor = this.connectionState().getStatementProcessor();
        if (currentProcessor != StatementProcessor.EMPTY) {
            if (currentProcessor.databaseName().equals(databaseName)) {
                return false;
            }
            throw new BoltProtocolBreachFatality(String.format("Changing database without closing the previous is forbidden. Current database name: '%s', new database name: '%s'.", currentProcessor.databaseName(), databaseName));
        }
        return true;
    }

    void setStatementProcessorProvider(StatementProcessorProvider statementProcessorProvider) {
        this.statementProcessorProvider = statementProcessorProvider;
    }

    private void extendThreadName(String databaseName) {
        if (!this.renameThreads) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        String originalName = currentThread.getName();
        String newName = originalName.replaceAll("^(.*)\\[DB=.*\\] $", "$1");
        if (databaseName != null) {
            newName = String.format("%s[DB=%s] ", newName, Objects.equals(databaseName, "") ? this.defaultDatabaseName : databaseName);
        }
        if (!Objects.equals(originalName, newName)) {
            currentThread.setName(newName);
        }
    }
}

