/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.v3.BoltProtocolV3;
import org.neo4j.bolt.v4.BoltProtocolV4;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarksParserV4;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.logging.internal.LogService;

public class DefaultBoltProtocolFactory
implements BoltProtocolFactory {
    private final BoltConnectionFactory connectionFactory;
    private final LogService logService;
    private final BoltStateMachineFactory stateMachineFactory;
    private final BookmarksParserV4 bookmarksParserV4;

    public DefaultBoltProtocolFactory(BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, LogService logService, DatabaseIdRepository databaseIdRepository, CustomBookmarkFormatParser customBookmarkFormatParser) {
        this.connectionFactory = connectionFactory;
        this.stateMachineFactory = stateMachineFactory;
        this.logService = logService;
        this.bookmarksParserV4 = new BookmarksParserV4(databaseIdRepository, customBookmarkFormatParser);
    }

    @Override
    public BoltProtocol create(long protocolVersion, BoltChannel channel) {
        if (protocolVersion == 3L) {
            return new BoltProtocolV3(channel, this.connectionFactory, this.stateMachineFactory, this.logService);
        }
        if (protocolVersion == 4L) {
            return new BoltProtocolV4(channel, this.connectionFactory, this.stateMachineFactory, this.bookmarksParserV4, this.logService);
        }
        return null;
    }
}

