/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.TransportSelectionHandler;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.UnauthenticatedChannelProtector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.logging.LogProvider;

public class SocketTransport
implements NettyServer.ProtocolInitializer {
    private final String connector;
    private final SocketAddress address;
    private final SslContext sslCtx;
    private final boolean encryptionRequired;
    private final LogProvider logging;
    private final TransportThrottleGroup throttleGroup;
    private final BoltProtocolFactory boltProtocolFactory;
    private final NetworkConnectionTracker connectionTracker;
    private final Duration channelTimeout;
    private final long maxMessageSize;
    private final ByteBufAllocator allocator;

    public SocketTransport(String connector, SocketAddress address, SslContext sslCtx, boolean encryptionRequired, LogProvider logging, TransportThrottleGroup throttleGroup, BoltProtocolFactory boltProtocolFactory, NetworkConnectionTracker connectionTracker, Duration channelTimeout, long maxMessageSize, ByteBufAllocator allocator) {
        this.connector = connector;
        this.address = address;
        this.sslCtx = sslCtx;
        this.encryptionRequired = encryptionRequired;
        this.logging = logging;
        this.throttleGroup = throttleGroup;
        this.boltProtocolFactory = boltProtocolFactory;
        this.connectionTracker = connectionTracker;
        this.channelTimeout = channelTimeout;
        this.maxMessageSize = maxMessageSize;
        this.allocator = allocator;
    }

    @Override
    public ChannelInitializer<Channel> channelInitializer() {
        return new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) {
                ch.config().setAllocator(SocketTransport.this.allocator);
                BoltChannel boltChannel = SocketTransport.this.newBoltChannel(ch);
                SocketTransport.this.connectionTracker.add((TrackedNetworkConnection)boltChannel);
                ch.closeFuture().addListener(future -> SocketTransport.this.connectionTracker.remove((TrackedNetworkConnection)boltChannel));
                SocketTransport.this.throttleGroup.install(ch);
                ch.closeFuture().addListener(future -> SocketTransport.this.throttleGroup.uninstall(ch));
                TransportSelectionHandler transportSelectionHandler = new TransportSelectionHandler(boltChannel, SocketTransport.this.sslCtx, SocketTransport.this.encryptionRequired, false, SocketTransport.this.logging, SocketTransport.this.boltProtocolFactory);
                ch.pipeline().addLast(new ChannelHandler[]{transportSelectionHandler});
            }
        };
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }

    private BoltChannel newBoltChannel(Channel ch) {
        UnauthenticatedChannelProtector protector = new UnauthenticatedChannelProtector(ch.pipeline(), this.channelTimeout, this.maxMessageSize);
        return new BoltChannel(this.connectionTracker.newConnectionId(this.connector), this.connector, ch, protector);
    }
}

