/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import java.time.Duration;
import org.neo4j.bolt.runtime.BoltConnectionFatality;

public class AuthenticationTimeoutHandler
extends ChannelInboundHandlerAdapter {
    private final Duration timeout;

    public AuthenticationTimeoutHandler(Duration timeout) {
        this.timeout = timeout;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.close();
            throw new BoltConnectionFatality(String.format("A connection '%s' is terminated because the client failed to finish authenticate within %s ms.", ctx.channel(), this.timeout.toMillis()), null);
        }
    }
}

