/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.messaging.ResponseMessageEncoder;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.packstream.PackProvider;
import org.neo4j.bolt.v3.messaging.encoder.FailureMessageEncoder;
import org.neo4j.bolt.v3.messaging.encoder.IgnoredMessageEncoder;
import org.neo4j.bolt.v3.messaging.encoder.RecordMessageEncoder;
import org.neo4j.bolt.v3.messaging.encoder.SuccessMessageEncoder;
import org.neo4j.bolt.v3.messaging.response.FatalFailureMessage;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.values.AnyValue;

public class BoltResponseMessageWriterV3
implements BoltResponseMessageWriter {
    private final PackOutput output;
    private final Neo4jPack.Packer packer;
    private final Log log;
    private final Map<Byte, ResponseMessageEncoder<ResponseMessage>> encoders;
    private RecordMessageEncoder recordMessageEncoder = new RecordMessageEncoder();

    public BoltResponseMessageWriterV3(PackProvider packerProvider, PackOutput output, LogService logService) {
        this.output = output;
        this.packer = packerProvider.newPacker(output);
        this.log = logService.getInternalLog(this.getClass());
        this.encoders = this.registerEncoders();
    }

    private Map<Byte, ResponseMessageEncoder<ResponseMessage>> registerEncoders() {
        HashMap<Byte, ResponseMessageEncoder<ResponseMessage>> encoders = new HashMap<Byte, ResponseMessageEncoder<ResponseMessage>>();
        encoders.put((byte)112, new SuccessMessageEncoder());
        encoders.put((byte)113, this.recordMessageEncoder);
        encoders.put((byte)126, new IgnoredMessageEncoder());
        encoders.put((byte)127, new FailureMessageEncoder(this.log));
        return encoders;
    }

    @Override
    public void write(ResponseMessage message) throws IOException {
        this.packCompleteMessageOrFail(message);
        if (message instanceof FatalFailureMessage) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    public PackOutput output() {
        return this.output;
    }

    public Log log() {
        return this.log;
    }

    private void packCompleteMessageOrFail(ResponseMessage message) throws IOException {
        boolean packingFailed = true;
        this.output.beginMessage();
        try {
            ResponseMessageEncoder<ResponseMessage> encoder = this.encoders.get(message.signature());
            if (encoder == null) {
                throw new BoltIOException((Status)Status.Request.InvalidFormat, String.format("Message %s is not supported in this protocol version.", message));
            }
            encoder.encode(this.packer, message);
            packingFailed = false;
            this.output.messageSucceeded();
        }
        catch (Throwable error) {
            if (packingFailed) {
                this.output.messageFailed();
                this.log.error("Failed to write full %s message because: %s", new Object[]{message, error.getMessage()});
            }
            throw error;
        }
    }

    @Override
    public void beginRecord(int numberOfFields) throws IOException {
        this.output.beginMessage();
        try {
            this.recordMessageEncoder.beginRecord(this.packer, numberOfFields);
        }
        catch (Throwable error) {
            this.output.messageFailed();
            this.log.error("Failed to write new record because: %s", new Object[]{error.getMessage()});
            throw error;
        }
    }

    @Override
    public void consumeField(AnyValue value) throws IOException {
        try {
            this.recordMessageEncoder.onField(this.packer, value);
        }
        catch (Throwable error) {
            this.log.error("Failed to write value %s because: %s", new Object[]{value, error.getMessage()});
            this.onError();
            throw error;
        }
    }

    @Override
    public void endRecord() throws IOException {
        this.output.messageSucceeded();
    }

    @Override
    public void onError() {
        this.output.messageReset();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

