/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.transport.pipeline.ProtocolHandshaker;
import org.neo4j.bolt.transport.pipeline.WebSocketFrameTranslator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class TransportSelectionHandler
extends ByteToMessageDecoder {
    private static final String WEBSOCKET_MAGIC = "GET ";
    private static final int MAX_WEBSOCKET_HANDSHAKE_SIZE = 65536;
    private static final int MAX_WEBSOCKET_FRAME_SIZE = 65536;
    private final BoltChannel boltChannel;
    private final SslContext sslCtx;
    private final boolean encryptionRequired;
    private final boolean isEncrypted;
    private final LogProvider logging;
    private final BoltProtocolFactory boltProtocolFactory;
    private final Log log;
    private final ChannelProtector channelProtector;

    TransportSelectionHandler(BoltChannel boltChannel, SslContext sslCtx, boolean encryptionRequired, boolean isEncrypted, LogProvider logging, BoltProtocolFactory boltProtocolFactory, ChannelProtector channelProtector) {
        this.boltChannel = boltChannel;
        this.sslCtx = sslCtx;
        this.encryptionRequired = encryptionRequired;
        this.isEncrypted = isEncrypted;
        this.logging = logging;
        this.boltProtocolFactory = boltProtocolFactory;
        this.log = logging.getLog(TransportSelectionHandler.class);
        this.channelProtector = channelProtector;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        if (this.detectSsl(in)) {
            this.assertSslNotAlreadyConfigured(ctx);
            this.enableSsl(ctx);
        } else if (TransportSelectionHandler.isHttp(in)) {
            this.switchToWebsocket(ctx);
        } else if (TransportSelectionHandler.isBoltPreamble(in)) {
            this.switchToSocket(ctx);
        } else {
            in.clear();
            ctx.close();
        }
    }

    private void assertSslNotAlreadyConfigured(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        if (p.get(SslHandler.class) != null) {
            this.log.error("Fatal error: multiple levels of SSL encryption detected. Terminating connection: %s", new Object[]{ctx.channel()});
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            if (Exceptions.contains((Throwable)cause, e -> e.getMessage().contains("Connection reset by peer"))) {
                this.log.warn("Fatal error occurred when initialising pipeline, remote peer unexpectedly closed connection: %s", new Object[]{ctx.channel()});
            } else {
                this.log.error("Fatal error occurred when initialising pipeline: " + ctx.channel(), cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    private static boolean isBoltPreamble(ByteBuf in) {
        return in.getInt(0) == 1616949271;
    }

    private boolean detectSsl(ByteBuf buf) {
        return this.sslCtx != null && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private static boolean isHttp(ByteBuf buf) {
        for (int i = 0; i < WEBSOCKET_MAGIC.length(); ++i) {
            if (buf.getUnsignedByte(buf.readerIndex() + i) == WEBSOCKET_MAGIC.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void enableSsl(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ctx.alloc())});
        p.addLast(new ChannelHandler[]{new TransportSelectionHandler(this.boltChannel, null, this.encryptionRequired, true, this.logging, this.boltProtocolFactory, this.channelProtector)});
        p.remove((ChannelHandler)this);
    }

    private void switchToSocket(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ChannelHandler[]{this.newHandshaker()});
        p.remove((ChannelHandler)this);
    }

    private void switchToWebsocket(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(65536), new WebSocketServerProtocolHandler("/", null, false, 65536), new WebSocketFrameAggregator(65536), new WebSocketFrameTranslator(), this.newHandshaker()});
        p.remove((ChannelHandler)this);
    }

    private ProtocolHandshaker newHandshaker() {
        return new ProtocolHandshaker(this.boltProtocolFactory, this.boltChannel, this.logging, this.encryptionRequired, this.isEncrypted, this.channelProtector);
    }
}

