/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.util.Map;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.ErrorReporter;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.HeapEstimator;

public class BoltStateMachineSPIImpl
implements BoltStateMachineSPI {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltStateMachineSPIImpl.class);
    public static final String BOLT_SERVER_VERSION_PREFIX = "Neo4j/";
    private final ErrorReporter errorReporter;
    private final Authentication authentication;
    private final String version;
    private final TransactionStateMachineSPIProvider transactionSpiProvider;
    private final BoltChannel boltChannel;

    public BoltStateMachineSPIImpl(LogService logging, Authentication authentication, TransactionStateMachineSPIProvider transactionSpiProvider, BoltChannel boltChannel) {
        this.errorReporter = new ErrorReporter(logging);
        this.authentication = authentication;
        this.transactionSpiProvider = transactionSpiProvider;
        this.boltChannel = boltChannel;
        this.version = BOLT_SERVER_VERSION_PREFIX + Version.getNeo4jVersion();
    }

    @Override
    public TransactionStateMachineSPIProvider transactionStateMachineSPIProvider() {
        return this.transactionSpiProvider;
    }

    @Override
    public void reportError(Neo4jError err) {
        this.errorReporter.report(err);
    }

    @Override
    public AuthenticationResult authenticate(Map<String, Object> authToken) throws AuthenticationException {
        return this.authentication.authenticate(authToken, this.boltChannel.info());
    }

    @Override
    public String version() {
        return this.version;
    }
}

