/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.scheduling;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.scheduling.BoltScheduler;
import org.neo4j.bolt.runtime.scheduling.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.scheduling.ExecutorBoltScheduler;
import org.neo4j.bolt.runtime.scheduling.ExecutorFactory;
import org.neo4j.bolt.runtime.scheduling.NettyThreadFactory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.Preconditions;

public class ExecutorBoltSchedulerProvider
extends LifecycleAdapter
implements BoltSchedulerProvider {
    private final Config config;
    private final ExecutorFactory executorFactory;
    private final JobScheduler scheduler;
    private final LogService logService;
    private final Log internalLog;
    private volatile BoltScheduler boltScheduler;
    private ExecutorService forkJoinThreadPool;

    public ExecutorBoltSchedulerProvider(Config config, ExecutorFactory executorFactory, JobScheduler scheduler, LogService logService) {
        this.config = config;
        this.executorFactory = executorFactory;
        this.scheduler = scheduler;
        this.logService = logService;
        this.internalLog = logService.getInternalLog(this.getClass());
    }

    public void init() {
        this.scheduler.setThreadFactory(Group.BOLT_WORKER, NettyThreadFactory::new);
        if (((Boolean)this.config.get(BoltConnector.enabled)).booleanValue()) {
            Preconditions.checkState((this.forkJoinThreadPool == null ? 1 : 0) != 0, (String)"ForkJoinPool already initialized, this should only be done once.");
            this.forkJoinThreadPool = new ForkJoinPool();
            this.boltScheduler = new ExecutorBoltScheduler("bolt", this.executorFactory, this.scheduler, this.logService, (Integer)this.config.get(BoltConnector.thread_pool_min_size), (Integer)this.config.get(BoltConnector.thread_pool_max_size), (Duration)this.config.get(BoltConnector.thread_pool_keep_alive), (Integer)this.config.get(BoltConnectorInternalSettings.unsupported_thread_pool_queue_size), this.forkJoinThreadPool, (Duration)this.config.get(BoltConnector.thread_pool_shutdown_wait_time), (BoltConnectorInternalSettings.KeepAliveRequestType)this.config.get(BoltConnectorInternalSettings.connection_keep_alive_type), (Duration)this.config.get(BoltConnectorInternalSettings.connection_keep_alive_streaming_scheduling_interval));
            this.boltScheduler.init();
        }
    }

    public void start() {
        if (this.boltScheduler != null) {
            this.boltScheduler.start();
        }
    }

    public void stop() {
        if (this.boltScheduler != null) {
            this.boltScheduler.stop();
        }
    }

    public void shutdown() {
        if (this.boltScheduler != null) {
            try {
                this.boltScheduler.shutdown();
            }
            catch (Throwable t) {
                this.internalLog.warn(String.format("An unexpected error occurred while shutting down BoltScheduler [%s]", this.boltScheduler.connector()), t);
            }
            this.boltScheduler = null;
        }
        if (this.forkJoinThreadPool != null) {
            this.forkJoinThreadPool.shutdown();
            this.forkJoinThreadPool = null;
        }
    }

    @Override
    public BoltScheduler get(BoltChannel channel) {
        if (this.boltScheduler == null) {
            throw new IllegalArgumentException(String.format("Provided channel instance [local: %s, remote: %s] is not bound to any known bolt listen addresses.", channel.serverAddress(), channel.clientAddress()));
        }
        return this.boltScheduler;
    }
}

