/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.dbapi.BookmarkMetadata;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractTransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.BoltAdapterSubscriber;
import org.neo4j.bolt.v4.runtime.CypherAdapterStreamV4;
import org.neo4j.bolt.v4.runtime.bookmarking.BookmarkWithDatabaseId;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachineV4SPI
extends AbstractTransactionStateMachineSPI {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionStateMachineV4SPI.class);
    private final NamedDatabaseId namedDatabaseId;

    public TransactionStateMachineV4SPI(BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI, BoltChannel boltChannel, SystemNanoClock clock, StatementProcessorReleaseManager resourceReleaseManger) {
        super(boltGraphDatabaseServiceSPI, boltChannel, clock, resourceReleaseManger);
        this.namedDatabaseId = boltGraphDatabaseServiceSPI.getNamedDatabaseId();
    }

    @Override
    public Bookmark newestBookmark(BoltTransaction tx) {
        BookmarkMetadata bookmarkMetadata = tx.getBookmarkMetadata();
        return bookmarkMetadata.toBookmark(BookmarkWithDatabaseId::new);
    }

    @Override
    protected BoltResultHandle newBoltResultHandle(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
        return new BoltResultHandleV4(statement, params, boltQueryExecutor);
    }

    @Override
    public boolean supportsNestedStatementsInTransaction() {
        return true;
    }

    private class BoltResultHandleV4
    extends AbstractTransactionStateMachineSPI.AbstractBoltResultHandle {
        BoltResultHandleV4(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
            super(TransactionStateMachineV4SPI.this, statement, params, boltQueryExecutor);
        }

        @Override
        protected BoltResult newBoltResult(QueryExecution result, BoltAdapterSubscriber subscriber, Clock clock) {
            return new CypherAdapterStreamV4(result, subscriber, clock, TransactionStateMachineV4SPI.this.namedDatabaseId.name());
        }
    }
}

