/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v43;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractBoltStateMachine;
import org.neo4j.bolt.v3.runtime.InterruptedState;
import org.neo4j.bolt.v4.runtime.AutoCommitState;
import org.neo4j.bolt.v4.runtime.InTransactionState;
import org.neo4j.bolt.v4.runtime.ReadyState;
import org.neo4j.bolt.v41.runtime.ConnectedState;
import org.neo4j.bolt.v43.runtime.FailedState;
import org.neo4j.bolt.v43.runtime.RouteMessageHandleStateDecorator;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.MapValue;

public class BoltStateMachineV43
extends AbstractBoltStateMachine {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltStateMachineV43.class);

    public BoltStateMachineV43(BoltStateMachineSPI boltSPI, BoltChannel boltChannel, Clock clock, DefaultDatabaseResolver defaultDatabaseResolver, MapValue connectionHints, MemoryTracker memoryTracker) {
        super(boltSPI, boltChannel, clock, defaultDatabaseResolver, connectionHints, memoryTracker);
    }

    @Override
    protected AbstractBoltStateMachine.States buildStates(MapValue connectionHints, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(ConnectedState.SHALLOW_SIZE + RouteMessageHandleStateDecorator.SHALLOW_SIZE + ReadyState.SHALLOW_SIZE + AutoCommitState.SHALLOW_SIZE + InTransactionState.SHALLOW_SIZE + FailedState.SHALLOW_SIZE + InterruptedState.SHALLOW_SIZE);
        ConnectedState connected = new ConnectedState(connectionHints);
        AutoCommitState autoCommitState = new AutoCommitState();
        InTransactionState inTransaction = new InTransactionState();
        FailedState failed = new FailedState();
        RouteMessageHandleStateDecorator<ReadyState> ready = RouteMessageHandleStateDecorator.decorate(new ReadyState(), failed);
        InterruptedState interrupted = new InterruptedState();
        connected.setReadyState(ready);
        ready.apply(it -> {
            it.setTransactionReadyState(inTransaction);
            it.setStreamingState(autoCommitState);
            it.setFailedState(failed);
            it.setInterruptedState(interrupted);
        });
        autoCommitState.setReadyState(ready);
        autoCommitState.setFailedState(failed);
        autoCommitState.setInterruptedState(interrupted);
        inTransaction.setReadyState(ready);
        inTransaction.setFailedState(failed);
        inTransaction.setInterruptedState(interrupted);
        failed.setInterruptedState(interrupted);
        interrupted.setReadyState(ready);
        return new AbstractBoltStateMachine.States(connected, failed);
    }
}

