/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v43.runtime;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.routing.ProcedureRoutingTableGetter;
import org.neo4j.bolt.routing.RoutingTableGetter;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.v43.messaging.request.RouteMessage;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;

public class RouteMessageHandleStateDecorator<T extends BoltStateMachineState>
implements BoltStateMachineState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RouteMessageHandleStateDecorator.class);
    private static final String ROUTING_TABLE_KEY = "rt";
    private static final String SYSTEM_DB_NAME = "system";
    private final T state;
    private final BoltStateMachineState failedState;
    private final RoutingTableGetter routingTableGetter;

    private RouteMessageHandleStateDecorator(T state, BoltStateMachineState failedState, RoutingTableGetter routingTableGetter) {
        this.state = state;
        this.failedState = failedState;
        this.routingTableGetter = routingTableGetter;
    }

    public static <T extends BoltStateMachineState> RouteMessageHandleStateDecorator<T> decorate(T state, BoltStateMachineState failedState) {
        return RouteMessageHandleStateDecorator.decorate(state, failedState, new ProcedureRoutingTableGetter());
    }

    public static <T extends BoltStateMachineState> RouteMessageHandleStateDecorator<T> decorate(T state, BoltStateMachineState failedState, RoutingTableGetter routingTableGetter) {
        if (state == null) {
            throw new NullPointerException("State should not be null");
        }
        if (failedState == null) {
            throw new NullPointerException("Failed State should not be null");
        }
        return new RouteMessageHandleStateDecorator<T>(state, failedState, routingTableGetter);
    }

    public void apply(Consumer<T> consumer) {
        consumer.accept(this.state);
    }

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        if (message instanceof RouteMessage) {
            return this.handleRouteMessage((RouteMessage)message, context);
        }
        return this.redirectToWrappedState(message, context);
    }

    private BoltStateMachineState handleRouteMessage(RouteMessage message, StateMachineContext context) throws BoltConnectionFatality {
        try {
            StatementProcessor statementProcessor = this.getStatementProcessor(context);
            ((CompletableFuture)this.routingTableGetter.get(statementProcessor, message.getRequestContext(), message.getBookmarks(), message.getDatabaseName()).thenAccept(routingTable -> context.connectionState().onMetadata(ROUTING_TABLE_KEY, (AnyValue)routingTable))).join();
            return this;
        }
        catch (CompletionException e) {
            context.handleFailure(e.getCause(), false);
            return this.failedState;
        }
        catch (Throwable e) {
            context.handleFailure(e, false);
            return this.failedState;
        }
    }

    private StatementProcessor getStatementProcessor(StateMachineContext context) throws BoltProtocolBreachFatality, BoltIOException {
        return context.setCurrentStatementProcessorForDatabase(SYSTEM_DB_NAME);
    }

    private BoltStateMachineState redirectToWrappedState(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        BoltStateMachineState resultState = this.state.process(message, context);
        return resultState == this.state ? this : resultState;
    }

    @Override
    public String name() {
        return this.state.name();
    }
}

