/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.MutableConnectionState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.StatementProcessorProvider;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class BoltStateMachineContextImpl
implements StateMachineContext,
StatementProcessorReleaseManager {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltStateMachineContextImpl.class);
    private final BoltStateMachine machine;
    private final BoltChannel boltChannel;
    private final BoltStateMachineSPI spi;
    private final MutableConnectionState connectionState;
    private final Clock clock;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final MemoryTracker memoryTracker;
    private StatementProcessorProvider statementProcessorProvider;

    public BoltStateMachineContextImpl(BoltStateMachine machine, BoltChannel boltChannel, BoltStateMachineSPI spi, MutableConnectionState connectionState, Clock clock, DefaultDatabaseResolver defaultDatabaseResolver, MemoryTracker memoryTracker) {
        this.machine = machine;
        this.boltChannel = boltChannel;
        this.spi = spi;
        this.connectionState = connectionState;
        this.clock = clock;
        this.memoryTracker = memoryTracker;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
    }

    @Override
    public void authenticatedAsUser(String username, String userAgent) {
        this.boltChannel.updateUser(username, userAgent);
    }

    @Override
    public void resolveDefaultDatabase() {
        this.boltChannel.updateDefaultDatabase(this.defaultDatabaseResolver.defaultDatabase(this.boltChannel.username()));
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        this.machine.handleFailure(cause, fatal);
    }

    @Override
    public boolean resetMachine() throws BoltConnectionFatality {
        return this.machine.reset();
    }

    @Override
    public BoltStateMachineSPI boltSpi() {
        return this.spi;
    }

    @Override
    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public String connectionId() {
        return this.machine.id();
    }

    @Override
    public void initStatementProcessorProvider(AuthenticationResult authResult, RoutingContext routingContext) {
        TransactionStateMachineSPIProvider transactionSpiProvider = this.spi.transactionStateMachineSPIProvider();
        this.setStatementProcessorProvider(new StatementProcessorProvider(authResult, transactionSpiProvider, this.clock, this, routingContext, this.memoryTracker));
    }

    @Override
    public StatementProcessor setCurrentStatementProcessorForDatabase(String databaseName) throws BoltProtocolBreachFatality, BoltIOException {
        if (this.isCurrentStatementProcessorNotSet(databaseName)) {
            StatementProcessor statementProcessor = this.statementProcessorProvider.getStatementProcessor(databaseName);
            this.connectionState().setStatementProcessor(statementProcessor);
            return statementProcessor;
        }
        return this.connectionState().getStatementProcessor();
    }

    @Override
    public void releaseStatementProcessor() {
        if (this.connectionState.getStatementProcessor() != StatementProcessor.EMPTY) {
            this.statementProcessorProvider.releaseStatementProcessor();
        }
        this.connectionState().clearStatementProcessor();
    }

    private boolean isCurrentStatementProcessorNotSet(String databaseName) throws BoltProtocolBreachFatality {
        StatementProcessor currentProcessor = this.connectionState().getStatementProcessor();
        if (currentProcessor != StatementProcessor.EMPTY) {
            if (currentProcessor.databaseName().equals(databaseName)) {
                return false;
            }
            throw new BoltProtocolBreachFatality(String.format("Changing database without closing the previous is forbidden. Current database name: '%s', new database name: '%s'.", currentProcessor.databaseName(), databaseName));
        }
        return true;
    }

    void setStatementProcessorProvider(StatementProcessorProvider statementProcessorProvider) {
        this.statementProcessorProvider = statementProcessorProvider;
    }

    @Override
    public BoltChannel channel() {
        return this.boltChannel;
    }
}

