/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.time.Duration;
import java.util.HashSet;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocol;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.packstream.ChunkedOutput;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.packstream.Neo4jPackV2;
import org.neo4j.bolt.packstream.PackOutput;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.BoltPatchListener;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarksParserV3;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public abstract class AbstractBoltProtocol
implements BoltProtocol {
    private final BoltChannel channel;
    private final Config config;
    private final LogService logging;
    private final TransportThrottleGroup throttleGroup;
    private final ChannelProtector channelProtector;
    private final MemoryTracker memoryTracker;
    private final BoltStateMachineFactory stateMachineFactory;
    private final BoltConnectionFactory connectionFactory;
    private final BookmarksParser bookmarksParser;
    private final MapValue connectionHints;

    public AbstractBoltProtocol(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, Config config, LogService logging, TransportThrottleGroup throttleGroup, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        this(channel, connectionFactory, stateMachineFactory, config, BookmarksParserV3.INSTANCE, logging, throttleGroup, channelProtector, memoryTracker);
    }

    protected AbstractBoltProtocol(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, Config config, BookmarksParser bookmarksParser, LogService logging, TransportThrottleGroup throttleGroup, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        this.channel = channel;
        this.config = config;
        this.logging = logging;
        this.throttleGroup = throttleGroup;
        this.stateMachineFactory = stateMachineFactory;
        this.connectionFactory = connectionFactory;
        this.bookmarksParser = bookmarksParser;
        this.channelProtector = channelProtector;
        this.memoryTracker = memoryTracker;
        MapValueBuilder hintBuilder = new MapValueBuilder(1);
        if (config.get(BoltConnectorInternalSettings.connection_keep_alive_type) == BoltConnectorInternalSettings.KeepAliveRequestType.ALL) {
            Duration keepAliveInterval = (Duration)config.get(BoltConnectorInternalSettings.connection_keep_alive);
            Integer keepAliveProbes = (Integer)config.get(BoltConnectorInternalSettings.connection_keep_alive_probes);
            hintBuilder.add("connection.recv_timeout_seconds", (AnyValue)Values.longValue((long)(keepAliveInterval.toSeconds() * (long)keepAliveProbes.intValue())));
        }
        this.connectionHints = hintBuilder.build();
    }

    @Override
    public void install() {
        BoltStateMachine stateMachine = this.stateMachineFactory.newStateMachine(this.version(), this.channel, this.connectionHints, this.memoryTracker);
        Neo4jPack neo4jPack = this.createPack(this.memoryTracker);
        BoltResponseMessageWriter messageWriter = this.createMessageWriter(neo4jPack, this.logging, this.memoryTracker);
        BoltConnection connection = this.connectionFactory.newConnection(this.channel, stateMachine, messageWriter);
        BoltRequestMessageReader messageReader = this.createMessageReader(connection, messageWriter, this.bookmarksParser, this.logging, this.channelProtector, this.memoryTracker);
        MessageDecoder messageDecoder = new MessageDecoder(neo4jPack, messageReader, this.logging);
        this.addBoltPatchesListener(this.channel.rawChannel(), messageWriter);
        this.addBoltPatchesListener(this.channel.rawChannel(), messageDecoder);
        this.memoryTracker.allocateHeap(ChunkDecoder.SHALLOW_SIZE + MessageAccumulator.SHALLOW_SIZE + MessageDecoder.SHALLOW_SIZE + HouseKeeper.SHALLOW_SIZE);
        this.channel.installBoltProtocol(new ChannelHandler[]{new ChunkDecoder(), new MessageAccumulator(this.config), messageDecoder, new HouseKeeper(connection, this.logging.getInternalLog(HouseKeeper.class))});
    }

    protected PackOutput createPackOutput(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(ChunkedOutput.SHALLOW_SIZE);
        return new ChunkedOutput(this.channel.rawChannel(), this.throttleGroup);
    }

    public Neo4jPack createPack(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(Neo4jPackV2.SHALLOW_SIZE);
        return new Neo4jPackV2();
    }

    protected abstract BoltRequestMessageReader createMessageReader(BoltConnection var1, BoltResponseMessageWriter var2, BookmarksParser var3, LogService var4, ChannelProtector var5, MemoryTracker var6);

    protected abstract BoltResponseMessageWriter createMessageWriter(Neo4jPack var1, LogService var2, MemoryTracker var3);

    private void addBoltPatchesListener(Channel channel, BoltPatchListener patchListener) {
        HashSet<BoltPatchListener> boltPatchesListeners = (HashSet<BoltPatchListener>)channel.attr(BoltChannel.BOLT_PATCH_LISTENERS).get();
        if (boltPatchesListeners == null) {
            boltPatchesListeners = new HashSet<BoltPatchListener>();
            channel.attr(BoltChannel.BOLT_PATCH_LISTENERS).set(boltPatchesListeners);
        }
        boltPatchesListeners.add(patchListener);
    }
}

