/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v41.runtime;

import io.netty.channel.Channel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.v3.messaging.BoltAuthenticationHelper;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.bolt.v41.messaging.request.HelloMessage;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class ConnectedState
implements BoltStateMachineState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConnectedState.class);
    private static final String CONNECTION_ID_KEY = "connection_id";
    private final MapValue hints;
    private BoltStateMachineState readyState;

    public ConnectedState(MapValue hints) {
        this.hints = hints;
    }

    @Override
    public BoltStateMachineState process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof HelloMessage) {
            HelloMessage helloMessage = (HelloMessage)message;
            String userAgent = helloMessage.userAgent();
            Map<String, Object> authToken = helloMessage.authToken();
            RoutingContext routingContext = helloMessage.routingContext();
            List<String> patchSettings = helloMessage.patchSettings();
            this.notifyListeners(context.channel().rawChannel(), patchSettings);
            if (patchSettings.contains("utc")) {
                context.connectionState().onMetadata("patch_bolt", (AnyValue)Values.stringArray((String[])new String[]{"utc"}));
            }
            if (BoltAuthenticationHelper.processAuthentication(userAgent, authToken, context, routingContext)) {
                context.resolveDefaultDatabase();
                context.connectionState().onMetadata(CONNECTION_ID_KEY, (AnyValue)Values.utf8Value((String)context.connectionId()));
                context.connectionState().onMetadata("hints", (AnyValue)this.hints);
                return this.readyState;
            }
            return null;
        }
        return null;
    }

    @Override
    public String name() {
        return "CONNECTED";
    }

    public void setReadyState(BoltStateMachineState readyState) {
        this.readyState = readyState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
    }

    private void notifyListeners(Channel channel, List<String> patchSettings) {
        if (!patchSettings.isEmpty()) {
            Set patchListeners = (Set)channel.attr(BoltChannel.BOLT_PATCH_LISTENERS).get();
            patchListeners.forEach(l -> l.handle(patchSettings));
        }
    }
}

