/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.txtracking;

import java.time.Duration;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.bolt.txtracking.TransactionIdTrackerException;
import org.neo4j.bolt.txtracking.TransactionIdTrackerMonitor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.time.Stopwatch;
import org.neo4j.time.SystemNanoClock;

public class TransactionIdTracker {
    private final DatabaseManagementService managementService;
    private final TransactionIdTrackerMonitor monitor;
    private final SystemNanoClock clock;

    public TransactionIdTracker(DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock) {
        this.managementService = managementService;
        this.monitor = (TransactionIdTrackerMonitor)monitors.newMonitor(TransactionIdTrackerMonitor.class, new String[0]);
        this.clock = clock;
    }

    public long newestTransactionId(NamedDatabaseId namedDatabaseId) {
        Database db = this.database(namedDatabaseId);
        try {
            return TransactionIdTracker.transactionIdStore(db).getLastCommittedTransactionId();
        }
        catch (RuntimeException e) {
            throw TransactionIdTracker.databaseUnavailable(db, e);
        }
    }

    public void awaitUpToDate(NamedDatabaseId namedDatabaseId, long oldestAcceptableTxId, Duration timeout) {
        Database db = this.database(namedDatabaseId);
        if (oldestAcceptableTxId <= 1L) {
            return;
        }
        long lastTransactionId = -1L;
        try {
            Stopwatch startTime = this.clock.startStopWatch();
            do {
                if (TransactionIdTracker.isNotAvailable(db)) {
                    throw TransactionIdTracker.databaseUnavailable(db);
                }
                lastTransactionId = TransactionIdTracker.currentTransactionId(db);
                if (oldestAcceptableTxId <= lastTransactionId) {
                    return;
                }
                this.waitWhenNotUpToDate();
            } while (!startTime.hasTimedOut(timeout));
            throw TransactionIdTracker.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId);
        }
        catch (RuntimeException e) {
            if (TransactionIdTracker.isNotAvailable(db)) {
                throw TransactionIdTracker.databaseUnavailable(db, e);
            }
            throw TransactionIdTracker.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId, e);
        }
    }

    private void waitWhenNotUpToDate() {
        this.monitor.onWaitWhenNotUpToDate();
        LockSupport.parkNanos(100L);
    }

    private static long currentTransactionId(Database db) {
        return TransactionIdTracker.transactionIdStore(db).getLastClosedTransactionId();
    }

    private static TransactionIdStore transactionIdStore(Database db) {
        return (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
    }

    private Database database(NamedDatabaseId namedDatabaseId) {
        try {
            GraphDatabaseAPI dbApi = (GraphDatabaseAPI)this.managementService.database(namedDatabaseId.name());
            Database db = (Database)dbApi.getDependencyResolver().resolveDependency(Database.class);
            if (TransactionIdTracker.isNotAvailable(db)) {
                throw TransactionIdTracker.databaseUnavailable(db);
            }
            return db;
        }
        catch (DatabaseNotFoundException e) {
            throw TransactionIdTracker.databaseNotFound(namedDatabaseId);
        }
    }

    private static boolean isNotAvailable(Database db) {
        return !db.getDatabaseAvailabilityGuard().isAvailable();
    }

    private static TransactionIdTrackerException databaseNotFound(NamedDatabaseId namedDatabaseId) {
        return new TransactionIdTrackerException((Status)Status.Database.DatabaseNotFound, "Database '" + namedDatabaseId.name() + "' does not exist");
    }

    private static TransactionIdTrackerException databaseUnavailable(Database db) {
        return TransactionIdTracker.databaseUnavailable(db, null);
    }

    private static TransactionIdTrackerException databaseUnavailable(Database db, Throwable cause) {
        return new TransactionIdTrackerException((Status)Status.Database.DatabaseUnavailable, "Database '" + db.getNamedDatabaseId().name() + "' unavailable", cause);
    }

    private static TransactionIdTrackerException unreachableDatabaseVersion(Database db, long lastTransactionId, long oldestAcceptableTxId) {
        return TransactionIdTracker.unreachableDatabaseVersion(db, lastTransactionId, oldestAcceptableTxId, null);
    }

    private static TransactionIdTrackerException unreachableDatabaseVersion(Database db, long lastTransactionId, long oldestAcceptableTxId, Throwable cause) {
        return new TransactionIdTrackerException((Status)Status.Transaction.BookmarkTimeout, "Database '" + db.getNamedDatabaseId().name() + "' not up to the requested version: " + oldestAcceptableTxId + ". Latest database version is " + lastTransactionId, cause);
    }
}

