/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.UUID;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.transaction.ProgramResultReference;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.FailSafeBoltStateMachineState;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class ReadyState
extends FailSafeBoltStateMachineState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);
    protected BoltStateMachineState streamingState;
    protected BoltStateMachineState txReadyState;
    public static final String FIELDS_KEY = "fields";
    public static final String FIRST_RECORD_AVAILABLE_KEY = "t_first";

    @Override
    public BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        context.connectionState().ensureNoPendingTerminationNotice();
        if (message instanceof RunMessage) {
            return this.processRunMessage((RunMessage)message, context);
        }
        if (message instanceof BeginMessage) {
            return this.processBeginMessage((BeginMessage)message, context);
        }
        return null;
    }

    @Override
    public String name() {
        return "READY";
    }

    public void setStreamingState(BoltStateMachineState streamingState) {
        this.streamingState = streamingState;
    }

    public void setTransactionReadyState(BoltStateMachineState txReadyState) {
        this.txReadyState = txReadyState;
    }

    protected BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        long start = context.clock().millis();
        String programId = UUID.randomUUID().toString();
        context.connectionState().setCurrentTransactionId(programId);
        ProgramResultReference result = context.getTransactionManager().runProgram(programId, context.getLoginContext(), "", message.statement(), message.params(), message.bookmarks(), message.getAccessMode().equals((Object)AccessMode.READ), message.transactionMetadata(), message.transactionTimeout(), context.connectionId());
        long end = context.clock().millis();
        context.connectionState().onMetadata(FIELDS_KEY, (AnyValue)Values.stringArray((String[])result.statementMetadata().fieldNames()));
        context.connectionState().onMetadata(FIRST_RECORD_AVAILABLE_KEY, (AnyValue)Values.longValue((long)(end - start)));
        return this.streamingState;
    }

    protected BoltStateMachineState processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        String transactionId = context.getTransactionManager().begin(context.getLoginContext(), "", message.bookmarks(), message.getAccessMode().equals((Object)AccessMode.READ), message.transactionMetadata(), message.transactionTimeout(), context.connectionId());
        context.connectionState().setCurrentTransactionId(transactionId);
        return this.txReadyState;
    }

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.txReadyState != null ? 1 : 0) != 0, (String)"TransactionReady state not set");
        super.assertInitialized();
    }
}

