/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.messaging;

import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class MessageMetadataParser {
    public static final String DB_NAME_KEY = "db";
    public static final String ABSENT_DB_NAME = "";

    static String parseDatabaseName(MapValue meta) throws BoltIOException {
        AnyValue anyValue = meta.get(DB_NAME_KEY);
        if (anyValue == Values.NO_VALUE) {
            return ABSENT_DB_NAME;
        }
        if (anyValue instanceof StringValue) {
            return ((StringValue)anyValue).stringValue();
        }
        throw new BoltIOException((Status)Status.Request.Invalid, "Expecting database name value to be a String value, but got: " + String.valueOf(anyValue));
    }
}

