/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.bolt.runtime.statemachine.StatementProcessor;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.AutoCommitStatementMetadata;
import org.neo4j.bolt.runtime.statemachine.impl.ExplicitTxStatementMetadata;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachine
implements StatementProcessor {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TransactionStateMachine.class);
    private final TransactionStateMachineSPI spi;
    final MutableTransactionState ctx;
    State state = State.AUTO_COMMIT;
    private final String databaseName;
    private final String transactionId;

    public TransactionStateMachine(String databaseName, TransactionStateMachineSPI spi, LoginContext loginContext, Clock clock, RoutingContext routingContext, String transactionId) {
        this.spi = spi;
        this.ctx = new MutableTransactionState(loginContext, clock, routingContext);
        this.databaseName = databaseName;
        this.transactionId = transactionId;
    }

    @Override
    public void beginTransaction(List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) throws KernelException {
        this.state = this.state.beginTransaction(this.ctx, this.spi, bookmarks, txTimeout, accessMode, txMetadata);
    }

    @Override
    public StatementMetadata run(String statement, MapValue params) throws KernelException {
        return this.run(statement, params, List.of(), null, AccessMode.WRITE, Map.of());
    }

    @Override
    public StatementMetadata run(String statement, MapValue params, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetaData) throws KernelException {
        this.state = this.state.run(this.ctx, this.spi, statement, params, bookmarks, txTimeout, accessMode, txMetaData);
        StatementMetadata metadata = this.ctx.lastStatementMetadata;
        this.ctx.lastStatementMetadata = null;
        return metadata;
    }

    @Override
    public Bookmark streamResult(int statementId, ResultConsumer resultConsumer) throws Throwable {
        return this.state.streamResult(this.ctx, this.spi, statementId, resultConsumer);
    }

    @Override
    public Bookmark commitTransaction() throws KernelException {
        try {
            BoltTransaction tx = this.ctx.currentTransaction;
            this.state = this.state.commitTransaction(this.ctx, this.spi);
            return TransactionStateMachine.newestBookmark(this.spi, tx);
        }
        catch (TransactionFailureException ex) {
            this.state = State.AUTO_COMMIT;
            throw ex;
        }
    }

    @Override
    public void rollbackTransaction() throws KernelException {
        this.state = this.state.rollbackTransaction(this.ctx, this.spi);
    }

    @Override
    public boolean hasOpenStatement() {
        return !this.ctx.statementOutcomes.isEmpty();
    }

    @Override
    public void reset() throws TransactionFailureException {
        State.terminateQueryAndRollbackTransaction(this.spi, this.ctx);
        this.state = State.AUTO_COMMIT;
    }

    @Override
    public void markCurrentTransactionForTermination() {
        BoltTransaction tx = this.ctx.currentTransaction;
        if (tx != null) {
            tx.markForTermination((Status)Status.Transaction.Terminated);
        }
    }

    @Override
    public Status validateTransaction() throws KernelException {
        Optional<Status> statusOpt;
        BoltTransaction tx = this.ctx.currentTransaction;
        if (tx != null && (statusOpt = tx.getReasonIfTerminated()).isPresent() && statusOpt.get().code().classification().rollbackTransaction()) {
            Status pendingTerminationNotice = statusOpt.get();
            this.reset();
            return pendingTerminationNotice;
        }
        return null;
    }

    @Override
    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public boolean hasTransaction() {
        return this.state == State.EXPLICIT_TRANSACTION;
    }

    private static Bookmark newestBookmark(TransactionStateMachineSPI spi, BoltTransaction tx) {
        return spi.newestBookmark(tx);
    }

    public String toString() {
        return "TransactionStateMachine{state=" + this.state + ", databaseName='" + this.databaseName + "'}";
    }

    static class StatementOutcome {
        BoltResultHandle resultHandle;
        BoltResult result;

        StatementOutcome(BoltResult result) {
            this.result = result;
        }

        StatementOutcome(BoltResultHandle resultHandle, BoltResult result) {
            this.resultHandle = resultHandle;
            this.result = result;
        }
    }

    static class MutableTransactionState {
        final RoutingContext routingContext;
        int statementCounter;
        final LoginContext loginContext;
        BoltTransaction currentTransaction;
        final Map<Integer, StatementOutcome> statementOutcomes = new HashMap<Integer, StatementOutcome>();
        final Clock clock;
        int lastStatementId = -1;
        StatementMetadata lastStatementMetadata;

        MutableTransactionState(LoginContext loginContext, Clock clock, RoutingContext routingContext) {
            this.clock = clock;
            this.loginContext = loginContext;
            this.routingContext = routingContext;
        }

        int nextStatementId() {
            return this.statementCounter++;
        }
    }

    static enum State {
        AUTO_COMMIT{

            @Override
            State beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) throws KernelException {
                this.beginTransaction(ctx, spi, bookmarks, txTimeout, accessMode, txMetadata, KernelTransaction.Type.EXPLICIT);
                return EXPLICIT_TRANSACTION;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            State run(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) throws KernelException {
                this.beginTransaction(ctx, spi, bookmarks, txTimeout, accessMode, txMetadata, KernelTransaction.Type.IMPLICIT);
                boolean failed = true;
                try {
                    int statementId = -1;
                    BoltTransaction boltQueryExecutor = ctx.currentTransaction;
                    BoltResultHandle resultHandle = spi.executeQuery(boltQueryExecutor, statement, params);
                    BoltResult result = 1.startExecution(resultHandle);
                    ctx.statementOutcomes.put(statementId, new StatementOutcome(resultHandle, result));
                    String[] fieldNames = result.fieldNames();
                    ctx.lastStatementMetadata = new AutoCommitStatementMetadata(fieldNames);
                    failed = false;
                }
                finally {
                    if (failed) {
                        1.closeTransaction(ctx, spi, false);
                    }
                }
                return AUTO_COMMIT;
            }

            private void beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, KernelTransaction.Type transactionType) {
                try {
                    ctx.currentTransaction = spi.beginTransaction(transactionType, ctx.loginContext, bookmarks, txTimeout, accessMode, txMetadata, ctx.routingContext);
                }
                catch (Throwable e) {
                    spi.transactionClosed();
                    throw e;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            Bookmark streamResult(MutableTransactionState ctx, TransactionStateMachineSPI spi, int statementId, ResultConsumer resultConsumer) throws Throwable {
                StatementOutcome outcome = ctx.statementOutcomes.get(statementId);
                if (outcome == null) {
                    throw new IllegalArgumentException("Unknown statement ID: " + statementId + ". Existing IDs: " + ctx.statementOutcomes.keySet());
                }
                boolean success = false;
                try {
                    1.consumeResult(ctx, statementId, outcome, resultConsumer);
                    if (!resultConsumer.hasMore()) {
                        BoltTransaction tx = ctx.currentTransaction;
                        1.closeTransaction(ctx, spi, true);
                        success = true;
                        Bookmark bookmark = TransactionStateMachine.newestBookmark(spi, tx);
                        return bookmark;
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        1.closeTransaction(ctx, spi, false);
                    }
                }
                return Bookmark.EMPTY_BOOKMARK;
            }

            @Override
            State commitTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("No current transaction to commit.", null));
            }

            @Override
            State rollbackTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) {
                int statementId = -1;
                ctx.statementOutcomes.put(statementId, new StatementOutcome(BoltResult.EMPTY));
                return AUTO_COMMIT;
            }
        }
        ,
        EXPLICIT_TRANSACTION{

            @Override
            State beginTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) throws KernelException {
                throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("Nested transactions are not supported.", null));
            }

            @Override
            State run(MutableTransactionState ctx, TransactionStateMachineSPI spi, String statement, MapValue params, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) throws KernelException {
                Preconditions.checkState((txTimeout == null ? 1 : 0) != 0, (String)"Explicit Transaction should not run with tx_timeout");
                Preconditions.checkState((boolean)MapUtils.isEmpty(txMetadata), (String)"Explicit Transaction should not run with tx_metadata");
                if (spi.isPeriodicCommit(statement)) {
                    throw new QueryExecutionKernelException((Throwable)new InvalidSemanticsException("A query with 'PERIODIC COMMIT' can only be executed in an implicit transaction, but tried to execute in an explicit transaction.", null));
                }
                int statementId = spi.supportsNestedStatementsInTransaction() ? ctx.nextStatementId() : -1;
                BoltResultHandle resultHandle = spi.executeQuery(ctx.currentTransaction, statement, params);
                BoltResult result = 2.startExecution(resultHandle);
                ctx.statementOutcomes.put(statementId, new StatementOutcome(resultHandle, result));
                String[] fieldNames = result.fieldNames();
                ctx.lastStatementId = statementId;
                ctx.lastStatementMetadata = new ExplicitTxStatementMetadata(fieldNames, statementId);
                return EXPLICIT_TRANSACTION;
            }

            @Override
            Bookmark streamResult(MutableTransactionState ctx, TransactionStateMachineSPI spi, int statementId, ResultConsumer resultConsumer) throws Throwable {
                StatementOutcome outcome;
                if (statementId == -1) {
                    statementId = ctx.lastStatementId;
                }
                if ((outcome = ctx.statementOutcomes.get(statementId)) == null) {
                    throw new IllegalArgumentException("Unknown statement ID: " + statementId + ". Existing IDs: " + ctx.statementOutcomes.keySet());
                }
                2.consumeResult(ctx, statementId, outcome, resultConsumer);
                return Bookmark.EMPTY_BOOKMARK;
            }

            @Override
            State commitTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                2.closeTransaction(ctx, spi, true);
                return AUTO_COMMIT;
            }

            @Override
            State rollbackTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi) throws KernelException {
                2.closeTransaction(ctx, spi, false);
                return AUTO_COMMIT;
            }
        };


        abstract State beginTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2, List<Bookmark> var3, Duration var4, AccessMode var5, Map<String, Object> var6) throws KernelException;

        abstract State run(MutableTransactionState var1, TransactionStateMachineSPI var2, String var3, MapValue var4, List<Bookmark> var5, Duration var6, AccessMode var7, Map<String, Object> var8) throws KernelException;

        abstract Bookmark streamResult(MutableTransactionState var1, TransactionStateMachineSPI var2, int var3, ResultConsumer var4) throws Throwable;

        abstract State commitTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2) throws KernelException;

        abstract State rollbackTransaction(MutableTransactionState var1, TransactionStateMachineSPI var2) throws KernelException;

        static void terminateQueryAndRollbackTransaction(TransactionStateMachineSPI spi, MutableTransactionState ctx) throws TransactionFailureException {
            State.terminateActiveStatements(ctx);
            State.closeTransaction(ctx, spi, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void closeTransaction(MutableTransactionState ctx, TransactionStateMachineSPI spi, boolean success) throws TransactionFailureException {
            State.closeActiveStatements(ctx, success);
            BoltTransaction tx = ctx.currentTransaction;
            ctx.currentTransaction = null;
            if (tx != null) {
                try (BoltTransaction boltTransaction = tx;){
                    if (success) {
                        tx.commit();
                    } else {
                        tx.rollback();
                    }
                }
                finally {
                    ctx.currentTransaction = null;
                    ctx.statementCounter = 0;
                    spi.transactionClosed();
                }
            }
        }

        private static void terminateActiveStatements(MutableTransactionState ctx) {
            Throwable error = null;
            for (StatementOutcome outcome : ctx.statementOutcomes.values()) {
                try {
                    BoltResult result;
                    BoltResultHandle resultHandle = outcome.resultHandle;
                    if (resultHandle != null) {
                        resultHandle.terminate();
                    }
                    if ((result = outcome.result) == null) continue;
                    result.close();
                }
                catch (Throwable e) {
                    if (error == null) {
                        error = new RuntimeException("Failed to terminate active statements.", e);
                        continue;
                    }
                    error.addSuppressed(e);
                }
            }
            ctx.statementOutcomes.clear();
            if (error != null) {
                throw error;
            }
        }

        private static void closeActiveStatements(MutableTransactionState ctx, boolean success) {
            Throwable error = null;
            for (StatementOutcome outcome : ctx.statementOutcomes.values()) {
                try {
                    BoltResult result;
                    BoltResultHandle resultHandle = outcome.resultHandle;
                    if (resultHandle != null) {
                        resultHandle.close(success);
                    }
                    if ((result = outcome.result) == null) continue;
                    result.close();
                }
                catch (Throwable e) {
                    if (error == null) {
                        error = new RuntimeException("Failed to close active statements.", e);
                        continue;
                    }
                    error.addSuppressed(e);
                }
            }
            ctx.statementOutcomes.clear();
            if (error != null) {
                throw error;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void consumeResult(MutableTransactionState ctx, int statementId, StatementOutcome outcome, ResultConsumer resultConsumer) throws Throwable {
            boolean success = false;
            try {
                resultConsumer.consume(outcome.result);
                success = true;
            }
            finally {
                if (!success || !resultConsumer.hasMore()) {
                    outcome.result.close();
                    BoltResultHandle resultHandle = outcome.resultHandle;
                    if (resultHandle != null) {
                        resultHandle.close(success);
                    }
                    ctx.statementOutcomes.remove(statementId);
                }
            }
        }

        static BoltResult startExecution(BoltResultHandle resultHandle) throws KernelException {
            try {
                return resultHandle.start();
            }
            catch (Throwable t) {
                resultHandle.close(false);
                throw t;
            }
        }
    }
}

