/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state.transition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.AbstractStateTransition;
import org.neo4j.bolt.fsm.state.transition.StateTransition;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

final class SequentialStateTransition<R extends RequestMessage>
extends AbstractStateTransition<R> {
    private final List<StateTransition<? super R>> transitions;

    public SequentialStateTransition(Class<R> requestType, List<StateTransition<? super R>> transitions) {
        super(requestType);
        if (transitions.size() < 2) {
            throw new IllegalArgumentException("Must provide at least two transitions");
        }
        this.transitions = new ArrayList<StateTransition<R>>(transitions);
    }

    public SequentialStateTransition(Class<R> requestType, StateTransition<? super R> ... transitions) {
        super(requestType);
        if (transitions.length < 2) {
            throw new IllegalArgumentException("Must provide at least two transitions");
        }
        this.transitions = Arrays.asList(transitions);
    }

    @Override
    public StateReference process(Context ctx, R message, ResponseHandler handler) throws StateMachineException {
        StateReference result;
        Iterator<StateTransition<R>> it = this.transitions.iterator();
        do {
            StateTransition<R> transition = it.next();
            result = transition.process(ctx, message, handler);
        } while (it.hasNext());
        return result;
    }
}

