/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.message.request.transaction;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.transaction.AbstractTransactionInitiatingMessage;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.values.virtual.MapValue;

public final class RunMessage
extends AbstractTransactionInitiatingMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final MapValue params;

    public RunMessage(String statement) {
        this(statement, MapValue.EMPTY);
    }

    public RunMessage(String statement, MapValue params) {
        this.statement = statement;
        this.params = params;
    }

    public RunMessage(String statement, MapValue params, List<String> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String databaseName, String impersonatedUser, NotificationsConfig notificationsConfig) {
        super(bookmarks, txTimeout, accessMode, txMetadata, databaseName, impersonatedUser, notificationsConfig);
        this.statement = statement;
        this.params = params;
    }

    public String statement() {
        return this.statement;
    }

    public MapValue params() {
        return this.params;
    }

    @Override
    public TransactionType type() {
        return TransactionType.IMPLICIT;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.params, that.params);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.statement, this.params);
    }

    @Override
    public String toString() {
        return "RunMessage{" + super.toString() + ", statement='" + this.statement + "', params=" + this.params + "}";
    }
}

