/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.neo4j.bolt.fsm.Context;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.fsm.error.ConnectionTerminating;
import org.neo4j.bolt.fsm.error.NoSuchStateException;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.fsm.error.state.IllegalRequestParameterException;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.protocol.common.connector.connection.ConnectionHandle;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

final class StateMachineImpl
implements StateMachine,
Context {
    private final ConnectionHandle connection;
    private final StateMachineConfiguration configuration;
    private final Log userLog;
    private final Log internalLog;
    private State defaultState;
    private State currentState;
    private boolean failed;
    private volatile boolean interrupted;

    StateMachineImpl(ConnectionHandle connection, StateMachineConfiguration configuration, LogService logging, State initialState) {
        this.connection = connection;
        this.configuration = configuration;
        this.userLog = logging.getUserLog(StateMachineImpl.class);
        this.internalLog = logging.getInternalLog(StateMachineImpl.class);
        this.currentState = this.defaultState = initialState;
    }

    @Override
    public ConnectionHandle connection() {
        return this.connection;
    }

    @Override
    public StateMachineConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public StateReference state() {
        return this.currentState.reference();
    }

    @Override
    public State lookup(StateReference reference) throws NoSuchStateException {
        return this.configuration.lookup(reference);
    }

    @Override
    public StateReference defaultState() {
        return this.defaultState.reference();
    }

    @Override
    public void defaultState(StateReference state) throws NoSuchStateException {
        this.defaultState = this.lookup(state);
    }

    @Override
    public boolean hasFailed() {
        return this.failed;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void reset() {
        this.failed = false;
        this.interrupted = false;
        this.currentState = this.defaultState;
    }

    @Override
    public boolean validate() {
        Transaction tx = this.connection.transaction().orElse(null);
        if (tx == null) {
            return false;
        }
        return tx.validate();
    }

    @Override
    public void process(RequestMessage message, ResponseHandler handler) throws StateMachineException {
        block6: {
            if (this.failed || this.interrupted) {
                if (!message.isIgnoredWhenFailed()) {
                    handler.onFailure(Error.from((Status)Status.Request.Invalid, "Message '" + message + "' cannot be handled by session in the " + this.state().name() + " state"));
                    throw new IllegalRequestParameterException("Request of type " + message.getClass().getName() + " is not permitted while failed or interrupted");
                }
                handler.onIgnored();
                return;
            }
            try {
                StateReference nextStateReference = this.currentState.process(this, message, handler);
                this.currentState = this.lookup(nextStateReference);
                handler.onSuccess();
            }
            catch (Throwable ex) {
                ConnectionTerminating terminating;
                this.failed = true;
                Error error = Error.from(ex);
                if (error.status().code().classification() == Status.Classification.DatabaseError) {
                    String errorMessage = error.queryId() != null ? String.format("Client triggered an unexpected error [%s]: %s, reference %s, queryId: %s.", error.status().code().serialize(), error.message(), error.reference(), error.queryId()) : String.format("Client triggered an unexpected error [%s]: %s, reference %s.", error.status().code().serialize(), error.message(), error.reference());
                    this.userLog.error(errorMessage);
                    if (error.cause() != null) {
                        this.internalLog.error(errorMessage, error.cause());
                    }
                }
                ex.printStackTrace();
                handler.onFailure(error);
                if (!error.isFatal() && (!(ex instanceof ConnectionTerminating) || !(terminating = (ConnectionTerminating)((Object)ex)).shouldTerminateConnection())) break block6;
                throw ex;
            }
        }
    }
}

