/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import io.netty.channel.Channel;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.fsm.StateMachine;
import org.neo4j.bolt.fsm.error.StateMachineException;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connection.Job;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.AbstractConnection;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.ConnectionMemoryTracker;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.fsm.error.AuthenticationStateTransitionException;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.notifications.NotificationsConfig;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.response.FailureMessage;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.bolt.protocol.error.BoltNetworkException;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.error.TransactionException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.NotificationConfiguration;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.FeatureToggles;

public class AtomicSchedulingConnection
extends AbstractConnection {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AtomicSchedulingConnection.class);
    private static final int BATCH_SIZE = FeatureToggles.getInteger(BoltServer.class, (String)"max_batch_size", (int)100);
    private final ExecutorService executor;
    private final Clock clock;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private volatile Thread workerThread;
    private final LinkedBlockingDeque<Job> jobs = new LinkedBlockingDeque();
    private final AtomicInteger remainingInterrupts = new AtomicInteger();
    private final AtomicReference<Transaction> transaction = new AtomicReference();

    public AtomicSchedulingConnection(Connector connector, String id, Channel channel, long connectedAt, MemoryTracker memoryTracker, LogService logService, ExecutorService executor, Clock clock) {
        super(connector, id, channel, connectedAt, memoryTracker, logService);
        this.executor = executor;
        this.clock = clock;
    }

    @Override
    public boolean isIdling() {
        return this.state.get() == State.IDLE && !this.hasPendingJobs();
    }

    @Override
    public boolean hasPendingJobs() {
        return !this.jobs.isEmpty();
    }

    @Override
    public void submit(RequestMessage message) {
        this.notifyListeners(listener -> listener.onRequestReceived(message));
        long queuedAt = this.clock.millis();
        this.submit((StateMachine fsm, ResponseHandler responseHandler) -> {
            long processedForMillis;
            long processingStartedAt = this.clock.millis();
            long queuedForMillis = processingStartedAt - queuedAt;
            this.notifyListeners(listener -> listener.onRequestBeginProcessing(message, queuedForMillis));
            try {
                this.log.debug("[%s] Beginning execution of %s (queued for %d ms)", new Object[]{this.id, message, queuedForMillis});
                fsm.process(message, responseHandler);
                processedForMillis = this.clock.millis() - processingStartedAt;
            }
            catch (StateMachineException ex) {
                try {
                    this.notifyListeners(listener -> listener.onRequestFailedProcessing(message, ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    long processedForMillis2 = this.clock.millis() - processingStartedAt;
                    this.notifyListeners(listener -> listener.onRequestCompletedProcessing(message, processedForMillis2));
                    this.log.debug("[%s] Completed execution of %s (took %d ms)", new Object[]{this.id, message, processedForMillis2});
                    throw throwable;
                }
            }
            this.notifyListeners(listener -> listener.onRequestCompletedProcessing(message, processedForMillis2));
            this.log.debug("[%s] Completed execution of %s (took %d ms)", new Object[]{this.id, message, processedForMillis});
        });
    }

    @Override
    public void submit(Job job) {
        this.jobs.addLast(job);
        this.schedule(true);
    }

    private void schedule(boolean submissionHint) {
        if (!submissionHint && !this.hasPendingJobs()) {
            return;
        }
        if (this.state.compareAndSet(State.IDLE, State.SCHEDULED)) {
            this.log.debug("[%s] Scheduling connection for execution", new Object[]{this.id});
            this.notifyListeners(ConnectionListener::onScheduled);
            try {
                this.executor.submit(this::executeJobs);
            }
            catch (RejectedExecutionException ex) {
                Error error = Error.from((Status)Status.Request.NoThreadsAvailable, Status.Request.NoThreadsAvailable.code().description());
                String message = String.format("[%s] Unable to schedule for execution since there are no available threads to serve it at the moment. You can retry at a later time or consider increasing max thread pool size for bolt connector(s).", this.id);
                this.userLog.error(message);
                this.notifyListenersSafely("requestResultFailure", listener -> listener.onResponseFailed(error));
                this.channel.writeAndFlush((Object)new FailureMessage(error.status(), error.message(), false));
                this.close();
            }
        }
    }

    @Override
    public boolean inWorkerThread() {
        Thread workerThread = this.workerThread;
        Thread currentThread = Thread.currentThread();
        return workerThread == currentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJobs() {
        Thread currentThread = Thread.currentThread();
        String originalThreadName = currentThread.getName();
        String customizedThreadName = String.format("%s [%s - %s]", originalThreadName, this.id, this.channel.remoteAddress());
        currentThread.setName(customizedThreadName);
        this.log.debug("[%s] Activating connection", new Object[]{this.id});
        this.workerThread = currentThread;
        this.notifyListeners(ConnectionListener::onActivated);
        try {
            this.doExecuteJobs();
        }
        catch (Throwable ex) {
            try {
                this.log.error("[" + this.id + "] Uncaught exception during job execution", ex);
                this.close();
            }
            catch (Throwable throwable) {
                this.notifyListeners(ConnectionListener::onIdle);
                this.log.debug("[%s] Returning to idle state", new Object[]{this.id});
                this.workerThread = null;
                currentThread.setName(originalThreadName);
                State previousState = this.state.compareAndExchange(State.SCHEDULED, State.IDLE);
                switch (previousState) {
                    case SCHEDULED: {
                        this.schedule(false);
                        break;
                    }
                    case CLOSING: {
                        this.doClose();
                        break;
                    }
                    case CLOSED: {
                        this.log.debug("[%s] Connection has already been terminated via its worker thread", new Object[]{this.id});
                    }
                }
                throw throwable;
            }
            this.notifyListeners(ConnectionListener::onIdle);
            this.log.debug("[%s] Returning to idle state", new Object[]{this.id});
            this.workerThread = null;
            currentThread.setName(originalThreadName);
            State previousState = this.state.compareAndExchange(State.SCHEDULED, State.IDLE);
            switch (previousState) {
                case SCHEDULED: {
                    this.schedule(false);
                    break;
                }
                case CLOSING: {
                    this.doClose();
                    break;
                }
                case CLOSED: {
                    this.log.debug("[%s] Connection has already been terminated via its worker thread", new Object[]{this.id});
                }
            }
        }
        this.notifyListeners(ConnectionListener::onIdle);
        this.log.debug("[%s] Returning to idle state", new Object[]{this.id});
        this.workerThread = null;
        currentThread.setName(originalThreadName);
        State previousState = this.state.compareAndExchange(State.SCHEDULED, State.IDLE);
        switch (previousState) {
            case SCHEDULED: {
                this.schedule(false);
                break;
            }
            case CLOSING: {
                this.doClose();
                break;
            }
            case CLOSED: {
                this.log.debug("[%s] Connection has already been terminated via its worker thread", new Object[]{this.id});
            }
        }
    }

    private void doExecuteJobs() {
        StateMachine fsm = this.fsm();
        ArrayList batch = new ArrayList(BATCH_SIZE);
        while (this.isActive()) {
            this.jobs.drainTo(batch, BATCH_SIZE);
            if (!batch.isEmpty()) {
                this.log.debug("[%s] Executing %d scheduled jobs", new Object[]{this.id, batch.size()});
                Iterator it = batch.iterator();
                while (it.hasNext() && this.isActive()) {
                    this.executeJob(fsm, (Job)it.next());
                }
            } else {
                if (this.transaction().isEmpty()) break;
                Job job = null;
                try {
                    this.log.debug("[%s] Waiting for additional jobs", new Object[]{this.id});
                    job = this.jobs.pollFirst(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    this.log.debug("[" + this.id + "] Worker interrupted while awaiting new jobs", (Throwable)ex);
                }
                if (job != null) {
                    this.executeJob(fsm, job);
                } else if (!fsm.validate()) break;
            }
            batch.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJob(StateMachine fsm, Job job) {
        this.channel.write((Object)StateSignal.BEGIN_JOB_PROCESSING);
        try {
            job.perform(fsm, this.responseHandler);
        }
        catch (AuthenticationStateTransitionException ex) {
            this.close();
            if (!(ex.getCause() instanceof AuthorizationExpiredException)) {
                this.userLog.warn("[" + this.id + "] " + ex.getMessage());
            }
        }
        catch (StateMachineException ex) {
            this.close();
            this.log.warn("[" + this.id + "] Terminating connection due to state machine error", (Throwable)ex);
        }
        catch (Throwable ex) {
            if (ex instanceof BoltNetworkException) {
                this.userLog.warn("[" + this.id + "] Terminating connection due to network error", ex);
            } else {
                this.userLog.error("[" + this.id + "] Terminating connection due to unexpected error", ex);
            }
            this.close();
        }
        finally {
            this.channel.write((Object)StateSignal.END_JOB_PROCESSING);
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.remainingInterrupts.get() != 0;
    }

    @Override
    public Transaction beginTransaction(TransactionType type, String databaseName, AccessMode mode, List<String> bookmarks, Duration timeout, Map<String, Object> metadata, NotificationsConfig transactionNotificationsConfig) throws TransactionException {
        if (databaseName == null) {
            databaseName = this.selectedDefaultDatabase();
        }
        NotificationConfiguration notificationsConfig = this.resolveNotificationsConfig(transactionNotificationsConfig);
        Transaction transaction = this.connector().transactionManager().create(type, this, databaseName, mode, bookmarks, timeout, metadata, notificationsConfig);
        if (!this.transaction.compareAndSet(null, transaction)) {
            try {
                transaction.close();
            }
            catch (TransactionException transactionException) {
                // empty catch block
            }
            throw new IllegalStateException("Nested transactions are not supported");
        }
        return transaction;
    }

    private NotificationConfiguration resolveNotificationsConfig(NotificationsConfig txConfig) {
        if (txConfig != null) {
            return txConfig.buildConfiguration(this.notificationsConfig);
        }
        if (this.notificationsConfig != null) {
            this.notificationsConfig.buildConfiguration(null);
        }
        return null;
    }

    @Override
    public Optional<Transaction> transaction() {
        return Optional.ofNullable(this.transaction.get());
    }

    @Override
    public void closeTransaction() throws TransactionException {
        Transaction tx = this.transaction.getAndSet(null);
        if (tx == null) {
            return;
        }
        tx.close();
    }

    @Override
    public void interrupt() {
        int previous = this.remainingInterrupts.getAndIncrement();
        if (previous == 0) {
            this.fsm.interrupt();
            Transaction tx = this.transaction.get();
            if (tx != null && !tx.hasFailed()) {
                tx.interrupt();
            }
        }
        this.submit((StateMachine fsm, ResponseHandler responseHandler) -> {
            if (this.reset()) {
                fsm.reset();
                responseHandler.onSuccess();
            } else {
                responseHandler.onIgnored();
            }
        });
    }

    @Override
    public boolean reset() {
        int current;
        do {
            if ((current = this.remainingInterrupts.get()) != 0) continue;
            return true;
        } while (!this.remainingInterrupts.compareAndSet(current, current - 1));
        if (current == 1) {
            try {
                this.closeTransaction();
            }
            catch (TransactionException ex) {
                this.log.warn("Failed to gracefully terminate transaction during reset", (Throwable)ex);
            }
            this.clearImpersonation();
            this.log.debug("[%s] Connection has been reset", new Object[]{this.id});
            return true;
        }
        this.log.debug("[%s] Interrupt has been cleared (%d interrupts remain active)", new Object[]{this.id, current - 1});
        return false;
    }

    @Override
    public boolean isActive() {
        State state = this.state.get();
        return state != State.CLOSING && state != State.CLOSED;
    }

    @Override
    public boolean isClosing() {
        return this.state.get() == State.CLOSING;
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    @Override
    public void close() {
        State originalState;
        boolean inWorkerThread = this.inWorkerThread();
        do {
            originalState = this.state.get();
            if ((inWorkerThread || originalState != State.CLOSING) && originalState != State.CLOSED) continue;
            return;
        } while (!this.state.compareAndSet(originalState, State.CLOSING));
        this.log.debug("[%s] Marked connection for closure", new Object[]{this.id});
        this.notifyListenersSafely("markForClosure", ConnectionListener::onMarkedForClosure);
        if (inWorkerThread || originalState == State.IDLE) {
            if (inWorkerThread) {
                this.log.debug("[%s] Close request from worker thread - Performing inline closure", new Object[]{this.id});
            } else {
                this.log.debug("[%s] Connection is idling - Performing inline closure", new Object[]{this.id});
            }
            this.doClose();
        } else {
            this.interrupt();
            this.submit((StateMachine fsm, ResponseHandler handler) -> {});
        }
    }

    private void doClose() {
        BoltProtocol protocol;
        if (!this.state.compareAndSet(State.CLOSING, State.CLOSED)) {
            return;
        }
        this.log.debug("[%s] Closing connection", new Object[]{this.id});
        try {
            Transaction transaction = this.transaction.getAndSet(null);
            if (transaction != null) {
                transaction.close();
            }
        }
        catch (TransactionException ex) {
            this.log.warn("[" + this.id + "] Failed to terminate transaction", (Throwable)ex);
        }
        while (!this.protocol.compareAndSet(protocol = (BoltProtocol)this.protocol.get(), null)) {
        }
        this.channel.close().addListener(f -> this.memoryTracker.close());
        boolean isNegotiatedConnection = this.fsm != null;
        this.notifyListenersSafely("close", connectionListener -> connectionListener.onConnectionClosed(isNegotiatedConnection));
        this.closeFuture.complete(null);
    }

    @Override
    public Future<?> closeFuture() {
        return this.closeFuture;
    }

    private static enum State {
        IDLE,
        SCHEDULED,
        CLOSING,
        CLOSED;

    }

    public static class Factory
    implements Connection.Factory {
        private final ExecutorService executor;
        private final Clock clock;
        private final LogService logService;

        public Factory(ExecutorService executor, Clock clock, LogService logService) {
            this.executor = executor;
            this.clock = clock;
            this.logService = logService;
        }

        @Override
        public AtomicSchedulingConnection create(Connector connector, String id, Channel channel) {
            ConnectionMemoryTracker memoryTracker = ConnectionMemoryTracker.createForPool(connector.memoryPool());
            memoryTracker.allocateHeap(SHALLOW_SIZE);
            return new AtomicSchedulingConnection(connector, id, channel, System.currentTimeMillis(), memoryTracker, this.logService, this.executor, this.clock);
        }
    }
}

