/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.event;

import java.util.List;
import java.util.function.Consumer;
import org.neo4j.bolt.event.EventPublisher;
import org.neo4j.function.ThrowingConsumer;

public class AbstractEventPublisher<L>
implements EventPublisher<L> {
    private final List<L> listeners;

    protected AbstractEventPublisher(List<L> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void dispatch(Consumer<L> eventFunction) {
        this.listeners.forEach(listener -> {
            try {
                eventFunction.accept(listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public void dispatchSafe(ThrowingConsumer<L, Exception> eventFunction) {
        this.listeners.forEach(listener -> {
            try {
                eventFunction.accept(listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @Override
    public <E extends Throwable> void dispatchThrowing(ThrowingConsumer<L, E> eventFunction) throws E {
        for (L listener : this.listeners) {
            eventFunction.accept(listener);
        }
    }

    @Override
    public void registerListener(L listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(L listener) {
        this.listeners.remove(listener);
    }
}

