/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.accounting.error;

import java.time.Clock;
import java.util.concurrent.atomic.AtomicReference;

final class TimeConstrainedCounter {
    private final long windowMillis;
    private final Clock clock;
    private final AtomicReference<State> state = new AtomicReference<State>(new State(0L, 0L));

    TimeConstrainedCounter(long windowMillis, Clock clock) {
        this.windowMillis = windowMillis;
        this.clock = clock;
    }

    public void increment() {
        this.incrementAndGet(1L);
    }

    public long incrementAndGet() {
        return this.incrementAndGet(1L);
    }

    public long incrementAndGet(long delta) {
        long now;
        State next;
        State previous;
        while (!this.state.compareAndSet(previous = this.state.get(), next = (now = this.clock.millis()) - previous.lastUpdate >= this.windowMillis ? new State(delta, now) : new State(previous.counter() + delta, now))) {
        }
        return next.counter;
    }

    private record State(long counter, long lastUpdate) {
    }
}

