/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.DateTimeValue;

public final class DateTimeZoneIdReader<CTX>
implements StructReader<CTX, DateTimeValue> {
    private static final DateTimeZoneIdReader<?> INSTANCE = new DateTimeZoneIdReader();

    private DateTimeZoneIdReader() {
    }

    public static <CTX> DateTimeZoneIdReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.DATE_TIME_ZONE_ID.getTag();
    }

    @Override
    public DateTimeValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        ZoneId zoneId;
        Instant instant;
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        long epochSecond = buffer.readInt();
        long nanos = buffer.readInt();
        String zoneName = buffer.readString();
        if (nanos > Integer.MAX_VALUE || nanos < Integer.MIN_VALUE) {
            throw new IllegalStructArgumentException("nanoseconds", "Value exceeds bounds");
        }
        try {
            instant = Instant.ofEpochSecond(epochSecond, nanos);
            zoneId = ZoneId.of(zoneName);
        }
        catch (ZoneRulesException ex) {
            throw new IllegalStructArgumentException("tz_id", String.format("Illegal zone identifier: \"%s\"", zoneName), ex);
        }
        catch (ArithmeticException | DateTimeException ex) {
            throw new IllegalStructArgumentException("seconds", String.format("Illegal epoch adjustment epoch seconds: %d+%d", epochSecond, nanos), ex);
        }
        return DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.ofInstant(instant, zoneId));
    }
}

