/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.HelloMessage;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;

public class ConnectedState
implements State {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ConnectedState.class);
    private static final String CONNECTION_ID_KEY = "connection_id";
    private State readyState;

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        if (message instanceof HelloMessage) {
            HelloMessage helloMessage = (HelloMessage)message;
            String userAgent = helloMessage.userAgent();
            Map<String, Object> authToken = helloMessage.authToken();
            RoutingContext routingContext = this.extractRoutingContext(helloMessage);
            if (this.processAuthentication(userAgent, authToken, context)) {
                List<Feature> enabledFeatures = helloMessage.features().stream().filter(feature -> context.connection().enableFeature((Feature)((Object)feature))).toList();
                context.initStatementProcessorProvider(routingContext);
                context.connectionState().onMetadata(CONNECTION_ID_KEY, (AnyValue)Values.utf8Value((String)context.connectionId()));
                MapValueBuilder connectionHints = new MapValueBuilder();
                context.connection().connector().connectionHintProvider().append(connectionHints);
                context.connectionState().onMetadata("hints", (AnyValue)connectionHints.build());
                if (!enabledFeatures.isEmpty()) {
                    ListValueBuilder builder = ListValueBuilder.newListBuilder((int)enabledFeatures.size());
                    enabledFeatures.forEach(feature -> builder.add((AnyValue)Values.stringValue((String)feature.getId())));
                    context.connectionState().onMetadata("patch_bolt", (AnyValue)builder.build());
                }
                return this.readyState;
            }
            return null;
        }
        return null;
    }

    protected RoutingContext extractRoutingContext(HelloMessage message) {
        return new RoutingContext(false, Collections.emptyMap());
    }

    protected boolean processAuthentication(String userAgent, Map<String, Object> authToken, StateMachineContext context) throws BoltConnectionFatality {
        try {
            StateMachineSPI boltSpi = context.boltSpi();
            MutableConnectionState connectionState = context.connectionState();
            connectionState.onMetadata("server", (AnyValue)Values.utf8Value((String)boltSpi.version()));
            AuthenticationFlag flags = context.connection().authenticate(authToken, userAgent);
            if (flags != null) {
                connectionState.onMetadata(flags.name().toLowerCase(), (AnyValue)Values.TRUE);
            }
            return true;
        }
        catch (Throwable t) {
            context.handleFailure(t, true);
            return false;
        }
    }

    @Override
    public String name() {
        return "CONNECTED";
    }

    public void setReadyState(State readyState) {
        this.readyState = readyState;
    }
}

