/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class HouseKeeperHandler
extends ChannelInboundHandlerAdapter {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HouseKeeperHandler.class);
    public static final String HANDLER_NAME = "housekeeper";
    private final InternalLog log;
    private Connection connection;
    private Connector connector;
    private boolean failed;

    public HouseKeeperHandler(InternalLogProvider logging) {
        this.log = logging.getLog(HouseKeeperHandler.class);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.connection = Connection.getConnection(ctx.channel());
        this.connector = this.connection.connector();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.failed || HouseKeeperHandler.isShuttingDown(ctx)) {
            return;
        }
        this.failed = true;
        try {
            if (Exceptions.contains((Throwable)cause, e -> e.getMessage() != null && e.getMessage().contains("Connection reset by peer"))) {
                this.connector.errorAccountant().notifyNetworkAbort(this.connection, cause);
            } else {
                this.log.error("Fatal error occurred when handling a client connection: " + ctx.channel(), cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    private static boolean isShuttingDown(ChannelHandlerContext ctx) {
        EventExecutorGroup eventLoopGroup = ctx.executor().parent();
        return eventLoopGroup != null && eventLoopGroup.isShuttingDown();
    }
}

