/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.error.struct;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.PackstreamStructException;

public class IllegalStructArgumentException
extends PackstreamStructException {
    private final String fieldName;

    public IllegalStructArgumentException(String fieldName, PackstreamReaderException cause) {
        super(String.format("Illegal value for field \"%s\": %s", fieldName, cause.getMessage()), cause);
        this.fieldName = fieldName;
    }

    public IllegalStructArgumentException(String fieldName, Throwable cause) {
        super(String.format("Illegal value for field \"%s\"", fieldName), cause);
        this.fieldName = fieldName;
    }

    public IllegalStructArgumentException(String fieldName, String message, Throwable cause) {
        super(String.format("Illegal value for field \"%s\": %s", fieldName, message), cause);
        this.fieldName = fieldName;
    }

    public IllegalStructArgumentException(String fieldName, String message) {
        this(fieldName, message, null);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Status status() {
        Throwable cause = this.getCause();
        if (cause instanceof PackstreamReaderException && cause instanceof Status.HasStatus) {
            return ((Status.HasStatus)cause).status();
        }
        return Status.Request.Invalid;
    }
}

